/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators.functions;

import gr.cite.clustermanager.actuators.ClientBase;
import gr.cite.clustermanager.exceptions.NoExecutionDetailsFound;
import gr.cite.clustermanager.model.functions.ExecutionDetails;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionMonitor
extends ClientBase
implements Serializable {
    private static final long serialVersionUID = -1352711364473503067L;
    static final Logger log = LoggerFactory.getLogger(ExecutionMonitor.class);
    private Map<String, ExecutionDetails> allExecutions = new HashMap<String, ExecutionDetails>();
    private PathChildrenCache cache = null;

    public ExecutionMonitor(String zkConnStr) throws Exception {
        super(zkConnStr);
        this.initializeClient();
    }

    private void initializeClient() throws Exception {
        try {
            this.cache = new PathChildrenCache(this.getClient(), "/functions", true);
            this.cache.start();
            log.debug("StartedMonitor");
        }
        catch (Exception e) {
            log.error("Could not start children client.");
            e.printStackTrace();
        }
        this.addListener(this.cache);
        log.debug("New Execution Monitor instance has been created");
    }

    private void addListener(PathChildrenCache cache) {
        PathChildrenCacheListener listener = new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        ExecutionMonitor.this.updateData(event);
                        break;
                    }
                    case CHILD_UPDATED: {
                        ExecutionMonitor.this.updateData(event);
                        break;
                    }
                    case CHILD_REMOVED: {
                        ExecutionMonitor.this.updateData(event);
                        break;
                    }
                    default: {
                        log.debug("Nothing happened!!!");
                    }
                }
            }
        };
        cache.getListenable().addListener((Object)listener);
    }

    private void updateData(PathChildrenCacheEvent event) throws IOException {
        String data = new String(event.getData().getData(), StandardCharsets.UTF_8);
        try {
            ExecutionDetails execDetails = (ExecutionDetails)this.getObjectMapper().readValue(data, ExecutionDetails.class);
            this.allExecutions.put(execDetails.getId(), execDetails);
        }
        catch (IOException e) {
            log.error("An error occured during deserialization of zookeeper information of running function executions", (Throwable)e);
            throw e;
        }
    }

    public Map<String, ExecutionDetails> getAllLatestExecutionDetails() {
        return this.allExecutions;
    }

    public ExecutionDetails getLatestExecutionDetailsOf(String executionID) throws NoExecutionDetailsFound {
        ExecutionDetails ed = this.getAllLatestExecutionDetails().get(executionID);
        if (ed == null) {
            throw new NoExecutionDetailsFound("There are no execution details for this execution id");
        }
        return ed;
    }

    public Map<String, ExecutionDetails> getLatestExecutionDetailsOf(String[] executionIDs) throws NoExecutionDetailsFound {
        HashMap<String, ExecutionDetails> execDetails = new HashMap<String, ExecutionDetails>();
        for (String executionID : executionIDs) {
            ExecutionDetails ed = this.allExecutions.get(executionID);
            if (ed == null) {
                throw new NoExecutionDetailsFound("There are no execution details for this execution id");
            }
            execDetails.put(executionID, ed);
        }
        return execDetails;
    }
}

