/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators.layers;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.clustermanager.model.layers.ZNodeData;
import gr.cite.clustermanager.model.layers.ZNodeDatum;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class DataCreatorGeoanalytics
implements Serializable {
    private static final long serialVersionUID = -8390406829555102503L;
    static final Logger log = Logger.getLogger(DataCreatorGeoanalytics.class);
    private static DataCreatorGeoanalytics instance = null;
    private static String zkConnStr;
    private static CuratorFramework client;
    private ObjectMapper objectMapper = new ObjectMapper();

    private DataCreatorGeoanalytics() {
    }

    public void addLayer(String layerId, ZNodeData.ZNodeStatus status, String gosIdentifier) throws Exception {
        log.debug((Object)("Adding layer " + layerId + " on " + gosIdentifier));
        ZNodeDatum zNodeDatum = this.getZNodeDatum(gosIdentifier);
        zNodeDatum.getZNodeDatas().add(new ZNodeData(layerId, status));
        this.setZNodeDatum(zNodeDatum, gosIdentifier);
        log.debug((Object)("Added layer " + layerId + " on " + gosIdentifier));
    }

    public void updateLayerState(String layerId, ZNodeData.ZNodeStatus status, String gosIdentifier) throws Exception {
        ZNodeDatum zNodeDatum = this.getZNodeDatum(gosIdentifier);
        List foundInAny = zNodeDatum.getZNodeDatas().parallelStream().map(znode -> {
            if (znode.getLayerId().equals(layerId)) {
                znode.setzNodeStatus(status);
                return true;
            }
            return false;
        }).filter(res -> res == true).collect(Collectors.toList());
        if (foundInAny.isEmpty()) {
            zNodeDatum.getZNodeDatas().add(new ZNodeData(layerId, status));
        }
        this.setZNodeDatum(zNodeDatum, gosIdentifier);
    }

    public void deleteLayer(String layerId, String gosIdentifier) throws Exception {
        ZNodeDatum zNodeDatum = this.getZNodeDatum(gosIdentifier);
        zNodeDatum.getZNodeDatas().remove(new ZNodeData(layerId, ZNodeData.ZNodeStatus.ACTIVE));
        this.setZNodeDatum(zNodeDatum, gosIdentifier);
    }

    private ZNodeDatum getZNodeDatum(String gosIdentifier) throws Exception {
        ZNodeDatum zNodeDatum;
        String znodePath = ZKPaths.makePath((String)"/layers", (String)gosIdentifier);
        byte[] rawData = (byte[])client.getData().forPath(znodePath);
        String dataStr = new String(rawData, StandardCharsets.UTF_8);
        try {
            zNodeDatum = (ZNodeDatum)this.objectMapper.readValue(dataStr, ZNodeDatum.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)"An error occured during deserialization", (Throwable)e);
            throw e;
        }
        return zNodeDatum;
    }

    private void setZNodeDatum(ZNodeDatum zNodeDatum, String gosIdentifier) throws Exception {
        String znodePath = ZKPaths.makePath((String)"/layers", (String)gosIdentifier);
        byte[] layersNamesByte = this.objectMapper.writeValueAsString((Object)zNodeDatum).getBytes();
        try {
            client.setData().forPath(znodePath, layersNamesByte);
        }
        catch (KeeperException.NoNodeException e) {
            e.printStackTrace();
            ((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(znodePath, layersNamesByte);
        }
    }

    public static synchronized DataCreatorGeoanalytics getInstance(String zkConnStr) {
        if (instance == null) {
            instance = new DataCreatorGeoanalytics();
            try {
                if (zkConnStr.isEmpty()) {
                    throw new Exception("Geoserver host parameter is not set on properties file.");
                }
                DataCreatorGeoanalytics.setZkConnStr(zkConnStr);
                client = CuratorFrameworkFactory.newClient((String)zkConnStr, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
                client.start();
                log.debug((Object)"New data monitor instance has been created");
            }
            catch (Exception e) {
                log.error((Object)"Could not start children client.");
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static String getZkConnStr() {
        return zkConnStr;
    }

    private static void setZkConnStr(String zkConnStr) {
        DataCreatorGeoanalytics.zkConnStr = zkConnStr;
    }

    static {
        client = null;
    }
}

