package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.HadoopBlackboardActions;
import eu.dnetlib.rmi.data.hadoop.HadoopService;

public class DeleteHdfsDirectoryJobNode extends BlackboardJobNode {

    private String cluster;

    private boolean force = false;

    private String path;

    @Override
    protected String obtainServiceId(final Env env) {
        return getServiceLocator().getServiceId(HadoopService.class);
    }

    @Override
    protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {

        job.setAction(HadoopBlackboardActions.DELETE_HDFS_PATH.toString());
        job.getParameters().put("cluster", getCluster());
        job.getParameters().put("force", String.valueOf(isForce()));
        job.getParameters().put("path", getPath());
    }

    public String getCluster() {
        return cluster;
    }

    public void setCluster(final String cluster) {
        this.cluster = cluster;
    }

    public boolean isForce() {
        return force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getPath() {
        return path;
    }

    public void setPath(final String path) {
        this.path = path;
    }
}
