/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.rdf;

import com.google.common.collect.Maps;
import eu.dnetlib.ariadneplus.publisher.SaxonHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordParserHelper {
    private static final Log log = LogFactory.getLog(RecordParserHelper.class);
    public static final String OAI_NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    public static final String DRI_NAMESPACE_URI = "http://www.driver-repository.eu/namespace/dri";
    public static final String RDF_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    @Autowired
    private SaxonHelper saxonHelper;
    private XPathSelector xpathSelectorObjIdentifier;
    private XPathSelector xpathSelectorCollectionDate;
    private XPathSelector xpathSelectorTransformationDate;
    private XPathSelector xpathSelectorDatasourceName;
    private XPathSelector xpathSelectorDatasourceApi;
    private XPathSelector xpathSelectorRDF;

    @PostConstruct
    public void init() throws SaxonApiException {
        this.prepareXpathSelectors();
    }

    public String getCollectionDate(String record) {
        return this.extractFromRecord(record, this.xpathSelectorCollectionDate);
    }

    public String getTransformationDate(String record) {
        return this.extractFromRecord(record, this.xpathSelectorTransformationDate);
    }

    public String getDatasourceName(String record) {
        return this.extractFromRecord(record, this.xpathSelectorDatasourceName);
    }

    public String getDatasourceApi(String record) {
        return this.extractFromRecord(record, this.xpathSelectorDatasourceApi);
    }

    public String getObjIdentifier(String record) {
        return this.extractFromRecord(record, this.xpathSelectorObjIdentifier);
    }

    public String getRDF(String record) {
        return this.extractFromRecord(record, this.xpathSelectorRDF);
    }

    private String extractFromRecord(String record, XPathSelector xPathSelector) {
        try {
            return this.saxonHelper.help().setSerializerProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes").evaluateSingleAsString(record, xPathSelector);
        }
        catch (SaxonApiException e) {
            log.error((Object)e);
            throw new RuntimeException("Cannot extract content from path " + xPathSelector.toString(), e);
        }
    }

    private void prepareXpathSelectors() throws SaxonApiException {
        HashMap namespaces = Maps.newHashMap();
        namespaces.put("oai", OAI_NAMESPACE_URI);
        namespaces.put("dri", DRI_NAMESPACE_URI);
        namespaces.put("rdf", RDF_NAMESPACE_URI);
        this.xpathSelectorObjIdentifier = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:objIdentifier/text()", (Map)namespaces);
        this.xpathSelectorCollectionDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfCollection/text()", (Map)namespaces);
        this.xpathSelectorTransformationDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfTransformation/text()", (Map)namespaces);
        this.xpathSelectorDatasourceName = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:datasourcename/text()", (Map)namespaces);
        this.xpathSelectorDatasourceApi = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:datasourceapi/text()", (Map)namespaces);
        this.xpathSelectorRDF = this.saxonHelper.help().prepareXPathSelector("//oai:metadata/rdf:RDF", (Map)namespaces);
    }

    public SaxonHelper getSaxonHelper() {
        return this.saxonHelper;
    }

    public void setSaxonHelper(SaxonHelper saxonHelper) {
        this.saxonHelper = saxonHelper;
    }
}

