package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;

/**
 * This class maps AO_Digital_Image.
 * One resource can have 0-N digital images.
 * One resource can have 0-1 primary digital image.
 * The current implementation does not completely cover the definition of the AO class.
 * @author enrico  ottonello
 */
public class DigitalImage {

    private String ariadneUri;
    private String primary;
    private String providerUri;

    public String getAriadneUri() {
        return ariadneUri;
    }

    public void setAriadneUri(String ariadneUri) {
        this.ariadneUri = ariadneUri;
    }

    public String getPrimary() {
        return primary;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public String getProviderUri() {
        return providerUri;
    }
    public void setProviderUri(String providerUri) {
        this.providerUri = providerUri;
    }

    public DigitalImage() {
    }

    public static DigitalImage fromJson(String json){
        return new Gson().fromJson(json, DigitalImage.class);
    }
}
