package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class PrepareEnvTransformHadoopJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(PrepareEnvTransformHadoopJobNode.class);

    private String ruleId;

    private String mdstoreInput;

    private String mdstoreOutput;

    @Value("${dnet.openaire.dhp.transformation.app.path}")
    private String oozieWfPath;

    @Override
    protected String execute(final NodeToken token) throws Exception {

        token.getEnv().setAttribute("oozieWfPath", getOozieWfPath());
        token.getEnv().setAttribute("timestamp", "" + System.currentTimeMillis());
        token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
        token.getEnv().setAttribute("mdstoreInput", getMdstoreInput());
        token.getEnv().setAttribute("mdstoreOutput", getMdstoreOutput());
        token.getEnv().setAttribute("transformationRule", getRuleId());
        return Arc.DEFAULT_ARC;

    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getMdstoreInput() {
        return mdstoreInput;
    }

    public void setMdstoreInput(String mdstoreInput) {
        this.mdstoreInput = mdstoreInput;
    }

    public String getMdstoreOutput() {
        return mdstoreOutput;
    }

    public void setMdstoreOutput(String mdstoreOutput) {
        this.mdstoreOutput = mdstoreOutput;
    }

    public String getOozieWfPath() {
        return oozieWfPath;
    }

    public void setOozieWfPath(String oozieWfPath) {
        this.oozieWfPath = oozieWfPath;
    }
}
