SELECT * FROM orgs
UNION
SELECT
		o.id                                                      AS organizationid,
		o.legalshortname                                          AS legalshortname,
		o.legalname                                               AS legalname,
		o.websiteurl                                              AS websiteurl,
		o.logourl                                                 AS logourl,
		null                                                      AS eclegalbody,
		null                                                      AS eclegalperson,
		null                                                      AS ecnonprofit,
		null                                                      AS ecresearchorganization,
		null                                                      AS echighereducation,
		null                                                      AS ecinternationalorganizationeurinterests,
		null                                                      AS ecinternationalorganization,
		null                                                      AS ecenterprise,
		null                                                      AS ecsmevalidated,
		null                                                      AS ecnutscode,
		o.dateofcollection                                        AS dateofcollection,
		false                                                     AS inferred,
		false                                                     AS deletedbyinference,
		0.9                                                       AS trust,
		''                                                        AS inferenceprovenance,
		d.id                                                      AS collectedfromid,
		d.officialname                                            AS collectedfromname,

		o.country || '@@@' || o.country || '@@@dnet:countries@@@dnet:countries' AS country,
		'sysimport:crosswalk:entityregistry@@@sysimport:crosswalk:entityregistry@@@dnet:provenance_actions@@@dnet:provenance_actions' AS provenanceaction,

		ARRAY[]::text[]                                              AS pid
FROM dsm_organizations o
	LEFT OUTER JOIN dsm_datasources d ON (d.id = o.collectedfrom);





