package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.repohi.UpdateMetaWfStatusJobNode;
import org.springframework.beans.factory.annotation.Required;

public class UpdateOpenaireMetaWfStatusJobNode extends UpdateMetaWfStatusJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private LocalDatasourceManager dsManager;

	@Override
	protected void updateDatasource(final String dsId, final String ifaceId) throws Exception {

		final String openaireDsId = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"/*[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']//FIELD/value[../key='OpenAireDataSourceId']/text()");

		if (openaireDsId.equals("openaire____::bootstrap")) {
			super.updateDatasource(dsId, ifaceId);
		} else {
			dsManager.setManaged(openaireDsId, true);
			dsManager.setActive(openaireDsId, ifaceId, true);
		}
	}


}
