<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dnet="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<xsl:variable name="rid" select="normalize-space(//repository/@rID)"/>
				<xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
				<xsl:variable name="apiId" select="concat('api_________::', $datasourceId, '::0')"/>
				<xsl:variable name="oUrl" select="normalize-space(//oUrl)"/>
				<xsl:variable name="oName" select="normalize-space(//oName)"/>
				<xsl:variable name="organizationId" select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')"/>
				<xsl:variable name="repositoryType">
					<xsl:choose>
						<xsl:when test="normalize-space(//repositoryType) = 'Institutional'">
							<xsl:value-of select="string('pubsrepository::institutional')"/>
						</xsl:when>
						<xsl:when test="normalize-space(//repositoryType) = 'Disciplinary'">
							<xsl:value-of select="string('pubsrepository::thematic')"/>
						</xsl:when>
						<xsl:when test="normalize-space(//repositoryType) = 'Aggregating'">
							<xsl:value-of select="string('aggregator::pubsrepository::unknown')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="string('pubsrepository::unknown')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:variable name="contenttypes">
					<xsl:for-each select=".//contentType">
						<xsl:if test="position() &gt; 1"> - </xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="languages">
					<xsl:for-each select=".//lName">
						<xsl:if test="position() &gt; 1">, </xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:variable>

				<xsl:variable name="subjects">
					<xsl:for-each select=".//clTitle">
						<xsl:if test="position() &gt; 1"> @@ </xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:variable>

				<ROWS>
					<ROW table="dsm_datasources">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="officialname">
							<xsl:value-of select="normalize-space(//rName)"/>
						</FIELD>
						<FIELD name="englishname">
							<xsl:value-of select="normalize-space(//rAcronym)"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:value-of select="normalize-space(//rUrl)"/>
						</FIELD>
						<FIELD name="contactemail">
							<xsl:value-of select="normalize-space(//pEmail)"/>
						</FIELD>
						<FIELD name="latitude" type="float">
							<xsl:value-of select="normalize-space(//paLatitude)"/>
						</FIELD>
						<FIELD name="longitude" type="float">
							<xsl:value-of select="normalize-space(//paLongitude)"/>
						</FIELD>
						<FIELD name="namespaceprefix">
							<xsl:value-of select="dnet:generateNsPrefix('od', $rid)"/>
						</FIELD>
						<FIELD name="languages">
							<xsl:value-of select="normalize-space($languages)"/>
						</FIELD>
						<FIELD name="od_contenttypes">
							<xsl:value-of select="normalize-space($contenttypes)"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="typology">
							<xsl:value-of select="$repositoryType"/>
						</FIELD>
						<FIELD name="provenanceaction">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="platform">
							<xsl:value-of select="normalize-space(//rSoftWareName)"/>
						</FIELD>
						<FIELD name="description">
							<xsl:value-of select="normalize-space(//rDescription)"/>
						</FIELD>
						
						<FIELD name="subjects">
							<xsl:value-of select="normalize-space($subjects)"/>
						</FIELD>
					</ROW>

					<ROW table="dsm_api">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="protocol">oai</FIELD>
						<FIELD name="datasource">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="contentdescription">metadata</FIELD>
						<FIELD name="typology">
							<xsl:value-of select="$repositoryType"/>
						</FIELD>
						<FIELD name="baseurl">
							<xsl:value-of select="normalize-space(//rOaiBaseUrl)"/>
						</FIELD>
						<FIELD name="metadata_identifier_path">//*[local-name()='header']/*[local-name()='identifier']</FIELD>
					</ROW>

					<ROW table="dsm_apiparams">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($apiId, '@@format')"/>
						</FIELD>
						<FIELD name="api">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="param">format</FIELD>
						<FIELD name="value">oai_dc</FIELD>
					</ROW>

					<ROW table="dsm_organizations">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
						<FIELD name="legalname">
							<xsl:value-of select="$oName"/>
						</FIELD>
						<FIELD name="legalshortname">
							<xsl:value-of select="normalize-space(//oAcronym)"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:choose>
								<xsl:when test="starts-with(normalize-space($oUrl), 'http')">
									<xsl:value-of select="normalize-space($oUrl)"/>
								</xsl:when>
								<xsl:when test="string-length(normalize-space($oUrl)) &gt; 0">
									<xsl:value-of select="concat('http://', normalize-space($oUrl))"/>
								</xsl:when>
							</xsl:choose>
						</FIELD>

						<FIELD name="country">
							<xsl:choose>
								<xsl:when test="normalize-space(//cIsoCode) = 'GB'">UK</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="normalize-space(//cIsoCode)"></xsl:value-of>
								</xsl:otherwise>
							</xsl:choose>
						</FIELD>

						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceaction">sysimport:crosswalk:entityregistry</FIELD>
					</ROW>

					<ROW table="dsm_datasource_organization">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($datasourceId, '@@', $organizationId)"/>
						</FIELD>
						<FIELD name="datasource">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="organization">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
					</ROW>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
