/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterManagedDatasourcesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FilterManagedDatasourcesJobNode.class);
    private String inputEprParam;
    private String outputEprParam;
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    @Autowired
    private MappedResultSetFactory mappedResultSetFactory;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.getInputEprParam()));
        Set managedDatasources = this.dsManager.listManagedDatasourceIds();
        log.info((Object)String.format("found %s managed datasources", managedDatasources.size()));
        W3CEndpointReference outputEpr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, s -> this.filterManaged((String)s, managedDatasources));
        token.getEnv().setAttribute(this.getOutputEprParam(), outputEpr.toString());
        return Arc.DEFAULT_ARC;
    }

    private String filterManaged(String data, Set<String> filter) throws IllegalStateException {
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(data));
            String dsId = doc.valueOf("/record/metadata/ROWS/ROW[@table = 'dsm_datasources']/FIELD[@name = 'id']/text()");
            if (filter.contains(dsId)) {
                doc.selectSingleNode("/record/metadata/ROWS").detach();
                ((Element)doc.selectSingleNode("/record/metadata")).addElement("ROWS");
                return doc.asXML();
            }
            return data;
        }
        catch (DocumentException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }
}

