/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api.objects;

import com.google.gson.Gson;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.miscutils.functional.string.EscapeXml;
import eu.dnetlib.msro.openaireplus.api.OpenAIRESubmitterUtils;
import eu.dnetlib.msro.openaireplus.api.objects.DatasourceEntry;
import eu.dnetlib.msro.openaireplus.api.objects.PidEntry;
import eu.dnetlib.msro.rmi.MSROException;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class ResultEntry {
    private String openaireId;
    private String originalId;
    private String title;
    private List<String> authors = new ArrayList<String>();
    private String publisher;
    private String description;
    private String language;
    private List<PidEntry> pids = new ArrayList<PidEntry>();
    private String licenseCode;
    private String embargoEndDate;
    private String type = "publication";
    private String resourceType;
    private String url;
    private String collectedFromId;
    private String hostedById;
    private List<String> contexts = new ArrayList<String>();
    private List<String> linksToProjects = new ArrayList<String>();
    private static long last_cache_update = 0L;
    private static final Map<String, Map<String, String>> cached_vocabularies = new HashMap<String, Map<String, String>>();
    private static final Map<String, DatasourceEntry> cached_datasources = new HashMap<String, DatasourceEntry>();
    private static final Map<String, String> cached_contexts = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(ResultEntry.class);

    public String getOpenaireId() {
        return this.openaireId;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    @ApiModelProperty(required=true)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="ISO Alpha-3 code. E.g. 'eng', 'ita'")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<PidEntry> getPids() {
        return this.pids;
    }

    public void setPids(List<PidEntry> pids) {
        this.pids = pids;
    }

    @ApiModelProperty(required=true, allowableValues="OPEN, CLOSED, RESTRICTED, EMBARGO, UNKNOWN, OTHER")
    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    @ApiModelProperty(required=true, value="Use 001 for articles, 021 for datasets. See: http://api.openaire.eu/vocabularies/dnet:publication_resource.")
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @ApiModelProperty(required=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(required=true, value="Use opendoar___::2659 for Zenodo Publications; re3data_____::r3d100010468 for Zenodo datasets; infrastruct::openaire for OpenAIRE portal.")
    public String getCollectedFromId() {
        return this.collectedFromId;
    }

    public void setCollectedFromId(String collectedFromId) {
        this.collectedFromId = collectedFromId;
    }

    public String getHostedById() {
        return this.hostedById;
    }

    public void setHostedById(String hostedById) {
        this.hostedById = hostedById;
    }

    @ApiModelProperty(value="E.g. fet, egi::classification::natsc::math::pure, egi::projects::EMI")
    public List<String> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<String> contexts) {
        this.contexts = contexts;
    }

    @ApiModelProperty(value="E.g. info:eu-repo/grantAgreement/EC/FP7/283595/EU//OpenAIREplus")
    public List<String> getLinksToProjects() {
        return this.linksToProjects;
    }

    public void setLinksToProjects(List<String> linksToProjects) {
        this.linksToProjects = linksToProjects;
    }

    @ApiModelProperty(allowableValues="publication, dataset")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEmbargoEndDate() {
        return this.embargoEndDate;
    }

    public void setEmbargoEndDate(String embargoEndDate) {
        this.embargoEndDate = embargoEndDate;
    }

    public String asOafRecord(VelocityEngine ve, ISLookUpService lookupService, String oafSchemaLocation) throws Exception {
        if (StringUtils.isBlank((String)this.getOriginalId()) && StringUtils.isBlank((String)this.getOpenaireId())) {
            throw new MSROException("One of the following fields is required: originalId or openaireId");
        }
        if (StringUtils.isBlank((String)this.getTitle())) {
            throw new MSROException("A required field is missing: title");
        }
        if (StringUtils.isBlank((String)this.getUrl())) {
            throw new MSROException("A required field is missing: url");
        }
        if (StringUtils.isBlank((String)this.getLicenseCode())) {
            throw new MSROException("A required field is missing: licenseCode");
        }
        if (StringUtils.isBlank((String)this.getResourceType())) {
            throw new MSROException("A required field is missing: resourceType");
        }
        if (StringUtils.isBlank((String)this.getCollectedFromId())) {
            throw new MSROException("A required field is missing: collectedFromId");
        }
        if (StringUtils.isBlank((String)this.getType())) {
            throw new MSROException("A required field is missing: type");
        }
        DatasourceEntry collectedFromEntry = ResultEntry.getDatasourceInfo(this.collectedFromId, lookupService);
        DatasourceEntry hostedByEntry = ResultEntry.getDatasourceInfo(this.hostedById, lookupService);
        if (StringUtils.isBlank((String)this.openaireId)) {
            this.setOpenaireId(ResultEntry.calculateOpenaireId(this.originalId, collectedFromEntry));
        }
        if (!this.openaireId.matches("^\\w{12}::\\w{32}$")) {
            throw new MSROException("Invalid openaireId: " + this.openaireId + " - regex ^\\w{12}::\\w{32}$ not matched");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("esc", new EscapeXml());
        model.put("util", new OpenAIRESubmitterUtils());
        model.put("pub", this);
        model.put("objIdentifier", this.getOpenaireId());
        model.put("oafSchemaLocation", oafSchemaLocation);
        model.put("resultTypes", ResultEntry.getVocabulary("dnet:result_typologies", lookupService));
        model.put("licenses", ResultEntry.getVocabulary("dnet:access_modes", lookupService));
        model.put("resourceTypes", ResultEntry.getVocabulary("dnet:publication_resource", lookupService));
        model.put("pidTypes", ResultEntry.getVocabulary("dnet:pid_types", lookupService));
        model.put("languages", ResultEntry.getVocabulary("dnet:languages", lookupService));
        model.put("contexts", ResultEntry.getContexts(lookupService));
        model.put("dateOfCollection", new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date()));
        model.put("collectedFrom", collectedFromEntry);
        model.put("hostedBy", hostedByEntry);
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)ve, (String)"/eu/dnetlib/msro/openaireplus/api/indexRecord.xml.vm", (String)"UTF-8", model);
    }

    private static String calculateOpenaireId(String originalId, DatasourceEntry collectedFromEntry) {
        return collectedFromEntry.getPrefix() + "::" + Hashing.md5((String)originalId);
    }

    public static String calculateOpenaireId(String originalId, String collectedFromId, ISLookUpService lookupService) throws ISLookUpException {
        return ResultEntry.calculateOpenaireId(originalId, ResultEntry.getDatasourceInfo(collectedFromId, lookupService));
    }

    private static synchronized DatasourceEntry getDatasourceInfo(String dsId, ISLookUpService lookupService) throws ISLookUpException {
        if (StringUtils.isBlank((String)dsId)) {
            return new DatasourceEntry("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", "Unknown Repository", "unknown_____");
        }
        if (!cached_datasources.containsKey(dsId)) {
            String query = "collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')//CONFIGURATION[./DATASOURCE_ORIGINAL_ID='" + dsId + "']/concat(./OFFICIAL_NAME, ' @@@ ', .//FIELD/value[../key='NamespacePrefix'])";
            String s = lookupService.getResourceProfileByQuery(query);
            String[] arr = s.split("@@@");
            DatasourceEntry ds = new DatasourceEntry(dsId, arr[0].trim(), arr[1].trim());
            if (StringUtils.isBlank((String)ds.getName()) || StringUtils.isBlank((String)ds.getPrefix())) {
                log.error((Object)("Invalid datasource id: " + dsId));
                throw new ISLookUpException("Invalid datasource id: " + dsId);
            }
            cached_datasources.put(dsId, ds);
        }
        return cached_datasources.get(dsId);
    }

    private static synchronized Map<String, String> getVocabulary(String voc, ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update < TimeUnit.MINUTES.toMillis(15L) && cached_vocabularies.containsKey(voc)) {
            return cached_vocabularies.get(voc);
        }
        String query = "collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code='" + voc + "']//TERM/concat(@code, ' @@@ ', @english_name)";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : lookupService.quickSearchProfile(query)) {
            String[] arr = s.split("@@@");
            map.put(arr[0].trim(), arr[1].trim());
        }
        cached_vocabularies.put(voc, map);
        last_cache_update = DateUtils.now();
        return map;
    }

    private static synchronized Map<String, String> getContexts(ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update > TimeUnit.MINUTES.toMillis(15L) || cached_contexts.isEmpty()) {
            String query = "collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)";
            cached_contexts.clear();
            for (String s : lookupService.quickSearchProfile("collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)")) {
                String[] arr = s.split("@@@");
                cached_contexts.put(arr[0].trim(), arr[1].trim());
            }
            last_cache_update = DateUtils.now();
        }
        return cached_contexts;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public String getAnyId() {
        return StringUtils.isNotBlank((String)this.openaireId) ? this.openaireId : this.originalId;
    }
}

