<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:utils="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions"
>

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>

    <xsl:variable name="dateFormat" select="string('yyyy')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::DFGF')"/>
    <xsl:variable name="fundingId">
        <xsl:value-of select="concat($funderID,'::',utils:md5(.//column[@name='Funding Programme']))"/>
    </xsl:variable>


    <xsl:template match="/">
        <record>

            <xsl:copy-of select=".//*[local-name()='header']"/>

            <metadata>
                <ROWS>
                    <xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='Project ID']))"/>
                    <xsl:variable name="startDate" select="replace(.//column[@name='Funding Start Year'],'/','-')"/>



                    <ROW table="projects">

                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="id">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="code">
                            <xsl:value-of select="normalize-space(.//column[@name='Project ID'])"/>
                        </FIELD>
                        <FIELD name="title">
                            <xsl:value-of select=".//column[@name='Project Title English**']"/>
                        </FIELD>
                        <FIELD name="startdate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$startDate"/>
                        </FIELD>


                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>
                        <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                        <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>


                        <FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>
                    </ROW>
                    <ROW table="project_fundingpath">
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
                        </FIELD>
                        <FIELD name="funding">
                            <xsl:value-of select="$fundingId"/>
                        </FIELD>
                        <FIELD name="project">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="startdate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$startDate"/>
                        </FIELD>

                    </ROW>
                </ROWS>
            </metadata>
        </record>
    </xsl:template>
</xsl:stylesheet>
