DROP TABLE IF EXISTS datacite_temp_sets;
CREATE TABLE IF NOT EXISTS datacite_temp_sets (
	_dnet_resource_identifier_ CHARACTER VARYING(2048) DEFAULT 'temp_' || md5(clock_timestamp() :: TEXT) || '_' || md5(random() :: TEXT),
	id                         CHARACTER VARYING(255) PRIMARY KEY,
	setname                    CHARACTER VARYING(255),
	setname_cleaned            CHARACTER VARYING(255),
	setspec                    CHARACTER VARYING(255),
	oa_source_id               CHARACTER VARYING(255) REFERENCES datasources (id)
);

DROP TABLE IF EXISTS datacite_temp_datarepos;

CREATE TABLE IF NOT EXISTS datacite_temp_datarepos (
	_dnet_resource_identifier_ CHARACTER VARYING(2048) DEFAULT 'temp_' || md5(clock_timestamp() :: TEXT) || '_' || md5(random() :: TEXT),
	id                         CHARACTER VARYING(255) PRIMARY KEY,
	name                       CHARACTER VARYING(512) NOT NULL,
	name_cleaned               CHARACTER VARYING(512) NOT NULL,
	class                      CHARACTER VARYING(255)
);

--CREATE INDEX datacite_sets__dnet_resource_identifier__idx ON datacite_sets (_dnet_resource_identifier_);
CREATE INDEX datacite_temp_datarepos__dnet_resource_identifier__idx
	ON datacite_temp_datarepos (_dnet_resource_identifier_);
