/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.blacklist;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.openaire.blacklist.BlacklistEntry;
import eu.dnetlib.openaire.blacklist.OpenaireIdResolver;
import eu.dnetlib.openaire.hadoop.utils.HBaseTableUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BlacklistManager {
    private static final Log log = LogFactory.getLog(BlacklistManager.class);
    @Value(value="${dnet.openaire.blacklist.db.name}")
    private String blacklistDatabaseName;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private OpenaireIdResolver openaireIdResolver;

    private Set<String> getOriginalIds(String id, String entityType) {
        Set<Object> originalIds = Sets.newHashSet();
        if (entityType.equals("result") || entityType.equals("organization") || entityType.equals("person")) {
            originalIds = this.openaireIdResolver.resolveIdentifier(id);
        }
        return originalIds;
    }

    public void addToBlacklist(BlacklistEntry entry) throws DatabaseException {
        Set<String> sourceIds = this.getOriginalIds(entry.getSourceObject(), entry.getSourceType());
        Set<String> targetIds = this.getOriginalIds(entry.getTargetObject(), entry.getTargetType());
        sourceIds.add(entry.getSourceObject());
        targetIds.add(entry.getTargetObject());
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        String addQuery = String.format("INSERT INTO blacklist(userid, relationship, provenance, iis_module, iis_status, status, source_object, source_type, target_object, target_type, ticket_id, original_source_objects, original_target_objects, note)  VALUES(%1$s, %2$s, %3$s, %4$s, %5$s, %6$s, %7$s, %8$s, %9$s, %10$s, %11$s, %12$s, %13$s, %14$s)", this.asSqlParam(entry.getUser()), this.asSqlParam(entry.getRelationship()), this.asSqlParam(entry.getProvenance()), this.asSqlParam(entry.getIisModule()), this.asSqlParam((Object)entry.getIisStatus()), this.asSqlParam((Object)entry.getStatus()), this.asSqlParam(entry.getSourceObject()), this.asSqlParam(entry.getSourceType()), this.asSqlParam(entry.getTargetObject()), this.asSqlParam(entry.getTargetType()), this.asSqlParam(entry.getTicketId()), this.asSqlParam(this.joinCollectionForSQL(sourceIds)), this.asSqlParam(this.joinCollectionForSQL(targetIds)), this.asSqlParam(entry.getNote()));
        log.debug((Object)"Adding new blacklist entry");
        this.safeUpdateSql(dbService, this.blacklistDatabaseName, addQuery);
    }

    private String joinCollectionForSQL(Collection<String> coll) {
        return "{\"" + StringUtils.join(coll, (String)"\",\"") + "\"}";
    }

    public void editBlacklistEntry(BlacklistEntry entry) throws DatabaseException {
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        String editQuery = String.format("UPDATE blacklist SET userid=%s, relationship=%s, provenance=%s, iis_module=%s, iis_status=%s, status=%s, source_type=%s, target_type=%s, ticket_id=%s, note=%s WHERE id=%s", this.asSqlParam(entry.getUser()), this.asSqlParam(entry.getRelationship()), this.asSqlParam(entry.getProvenance()), this.asSqlParam(entry.getIisModule()), this.asSqlParam((Object)entry.getIisStatus()), this.asSqlParam((Object)entry.getStatus()), this.asSqlParam(entry.getSourceType()), this.asSqlParam(entry.getTargetType()), this.asSqlParam(entry.getTicketId()), this.asSqlParam(entry.getNote()), this.asSqlParam(entry.getId()));
        log.debug((Object)("Editing blacklist entry: " + entry.getId()));
        this.safeUpdateSql(dbService, this.blacklistDatabaseName, editQuery);
    }

    private String asSqlParam(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Number || o instanceof Boolean) {
            return o.toString();
        }
        return "'" + o.toString() + "'";
    }

    public void deleteFromBlacklist(int entryId) throws DatabaseException {
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        log.debug((Object)("Deleting entry " + entryId + " from blacklist"));
        this.safeUpdateSql(dbService, this.blacklistDatabaseName, String.format("DELETE FROM blacklist WHERE id='%s' ", entryId));
    }

    public Iterable<BlacklistEntry> getBlacklist() throws DatabaseException {
        String sqlQuery = "SELECT * from blacklist order by ticket_id";
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.blacklistDatabaseName, "SELECT * from blacklist order by ticket_id");
        IterableResultSetClient iter = this.resultSetClientFactory.getClient(epr);
        return this.getBlacklistIterable((Iterable<String>)iter);
    }

    public W3CEndpointReference getAcceptedBlacklistEntries() throws DatabaseException {
        String sqlQuery = "SELECT source_type, unnest(original_source_objects) as source, target_type, unnest(original_target_objects) as target, relationship FROM blacklist WHERE status = 'ACCEPTED'";
        return ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.blacklistDatabaseName, "SELECT source_type, unnest(original_source_objects) as source, target_type, unnest(original_target_objects) as target, relationship FROM blacklist WHERE status = 'ACCEPTED'");
    }

    private void safeUpdateSql(DatabaseService dbService, String dbName, String sql) throws DatabaseException {
        log.info((Object)sql);
        dbService.updateSQL(dbName, sql);
    }

    public Iterable<BlacklistEntry> getBlacklistIterable(Iterable<String> xmlEntries) {
        return new MappedCollection(xmlEntries, (UnaryFunction)new UnaryFunction<BlacklistEntry, String>(){

            public BlacklistEntry evaluate(String dbEntry) {
                SAXReader saxReader = new SAXReader();
                BlacklistEntry be = new BlacklistEntry();
                try {
                    List targets;
                    List sources;
                    Document doc = saxReader.read((Reader)new StringReader(dbEntry));
                    be.setId(Integer.parseInt(doc.selectSingleNode("//FIELD[./@name='id']").getText()));
                    be.setCreationDate(doc.selectSingleNode("//FIELD[./@name='creation_time']").getText());
                    be.setLastUpdateDate(doc.selectSingleNode("//FIELD[./@name='last_update_time']").getText());
                    be.setNote(doc.selectSingleNode("//FIELD[./@name='note']").getText());
                    be.setRelationship(doc.selectSingleNode(".//FIELD[./@name='relationship']").getText());
                    be.setStatus(STATUS.valueOf(StringUtils.upperCase((String)doc.selectSingleNode("//FIELD[./@name='status']").getText())));
                    be.setTicketId(doc.selectSingleNode("//FIELD[./@name='ticket_id']").getText());
                    be.setUser(doc.selectSingleNode("//FIELD[./@name='userid']").getText());
                    be.setSourceObject(doc.selectSingleNode("//FIELD[./@name='source_object']").getText());
                    be.setSourceType(doc.selectSingleNode("//FIELD[./@name='source_type']").getText());
                    be.setTargetObject(doc.selectSingleNode("//FIELD[./@name='target_object']").getText());
                    be.setTargetType(doc.selectSingleNode("//FIELD[./@name='target_type']").getText());
                    String provenance = doc.selectSingleNode("//FIELD[./@name='provenance']").getText();
                    be.setProvenance(provenance);
                    if (provenance.equalsIgnoreCase("iis")) {
                        be.setIisModule(doc.selectSingleNode("//FIELD[./@name='iis_module']").getText());
                        be.setIisStatus(IIS_STATUS.valueOf(StringUtils.upperCase((String)doc.selectSingleNode("//FIELD[./@name='iis_status']").getText())));
                    }
                    if ((sources = doc.selectNodes("//FIELD[./@name='original_source_objects']/ITEM")) != null && !sources.isEmpty()) {
                        for (Element e : sources) {
                            be.getOriginalSourceObjects().add(e.getText());
                        }
                    }
                    if ((targets = doc.selectNodes("//FIELD[./@name='original_target_objects']/ITEM")) != null && !targets.isEmpty()) {
                        for (Element e : targets) {
                            be.getOriginalTargetObjects().add(e.getText());
                        }
                    }
                }
                catch (DocumentException e) {
                    log.error((Object)e);
                    throw new RuntimeException(e);
                }
                return be;
            }
        });
    }

    public Set<String> getListOfRelationships() {
        return HBaseTableUtils.listRelationships();
    }

    public static enum STATUS {
        PENDING,
        ACCEPTED,
        REFUSED,
        DELETED;

    }

    public static enum IIS_STATUS {
        UNSOLVED,
        SOLVED;

    }
}

