var blacklistControllers = angular.module('blacklistControllers', []);

function common_init($scope, $http, $sce, $location) {
    initSpinner();
    $scope.showError = function (error) {
        show_notification("error", error);
    };
    $scope.showNotification = function (message) {
        show_notification("info", message);
    };
    $scope.showSpinner = function () {
        showSpinner();
    };
    $scope.hideSpinner = function () {
        hideSpinner();
    };
    $scope.to_trusted = function (html) {
        return $sce.trustAsHtml(html);
    };
    $scope.go = function (path) {
        $location.path(path);
    };
    $scope.encodeValue = function (val) {
        return val;
    };
}

blacklistControllers.controller('blacklistCtrl', [
    '$scope', '$http', '$sce', '$location', function ($scope, $http, $sce, $location) {
        common_init($scope, $http, $sce, $location);

        $scope.blacklist = [];
		$scope.relationTypes = [];
		$scope.blacklistFilter = '';
		
		$scope.entryToEdit = {};
		$scope.showBlacklistForm = false;
		$scope.modeBlacklistForm = '';
		
		$scope.predicate = '';
		$scope.reverse = true;
		
		$scope.order = function(predicate) {
			$scope.reverse = ($scope.predicate === predicate) ? !$scope.reverse : false;
			$scope.predicate = predicate;
		};
		
        $scope.getBlacklist = function () {
            $scope.blacklist = [];

            $scope.showSpinner();

            $http.get('blacklist/getBlacklist.do').success(function (data) {
                $scope.hideSpinner();
                $scope.blacklist = data;
            }).error(function () {
	            $scope.showError('Problems getting the blacklist');
                $scope.hideSpinner();
            });
        };

        $scope.getBlacklist();

		$scope.prepareNewEntry = function() {
			$scope.modeBlacklistForm = 'ADD';
			$scope.entryToEdit = {};
			$scope.showBlacklistForm = true;
		};
		
        $scope.prepareForEdit = function (entry) {
			$scope.modeBlacklistForm = 'UPDATE';
        	$scope.entryToEdit = angular.copy(entry);
			$scope.showBlacklistForm = true;
        };
		
		$scope.addBlacklistEntry = function (newEntry) {
            $scope.showSpinner();
            $http.post('blacklist/addToBlacklist.do', newEntry).success(function (data) {
            	$scope.hideSpinner();
            	if (data === 'false') {
                    $scope.showError('Cannot add blacklist entry: probably it is a duplicate')
                } else {
                    $scope.showNotification('Blacklist entry successfully added');
                    $scope.getBlacklist();
                }
            }).error(function () {
            	$scope.hideSpinner();
                $scope.showError('ERROR: cannot add blacklist entry');
            });
        };

        $scope.editBlacklistEntry = function (entry) {
            $scope.showSpinner();
            $http.post('blacklist/editBlacklistEntry.do', entry).success(function (data) {
            	$scope.hideSpinner();
            	if (data === 'false') {
                    $scope.showError('Cannot edit entry')
                } else {
                	$scope.showNotification('Blacklist entry successfully edited');
                	$scope.getBlacklist();
                }
            }).error(function () {
            	$scope.hideSpinner();
            	$scope.showError('ERROR: cannot edit blacklist entry');
            });
        };

        $scope.deleteFromBlacklist = function (id) {
            var result = confirm("Are you sure you want to delete it?");
            if (result) {
                $scope.showSpinner();
                $http.post('blacklist/deleteFromBlacklist.do', id).success(function (data) {
                	$scope.hideSpinner();
                    if (data === 'false') {
                        $scope.showError('Cannot delete entry')
                    } else {
                        $scope.showNotification('Blacklist entry successfully deleted');
                        $scope.getBlacklist();
                    }
                }).error(function () {
                	$scope.hideSpinner();
                    $scope.showError('ERROR: cannot delete blacklist entry');
                });
            }
        };
    }
]);
