package eu.dnetlib.functionality.modular.ui.blacklist;

import java.util.List;
import java.util.Set;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.openaire.blacklist.BlacklistEntry;
import eu.dnetlib.openaire.blacklist.BlacklistManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by alessia on 18/09/15.
 */
@Controller
public class BlacklistInternalController extends AbstractAjaxController {

    private static final Log log = LogFactory.getLog(BlacklistInternalController.class); // NOPMD by marko on 11/24/08 5:02 PM

    @Resource
    private BlacklistManager blacklistManager;

    @ResponseBody
    @RequestMapping(value = "/ui/blacklist/getBlacklist.do")
    public List<BlacklistEntry> getBlacklist() throws DatabaseException {
        log.debug("getBlacklist");
        return Lists.newArrayList(this.blacklistManager.getBlacklist());
    }

    @ResponseBody
    @RequestMapping(value = "/ui/blacklist/addToBlacklist.do")
    public void addToBlacklist(@RequestBody(required = true) final BlacklistEntry entry) throws DatabaseException {
        log.debug("addToBlacklist");
        this.blacklistManager.addToBlacklist(entry);
    }

    @ResponseBody
    @RequestMapping(value = "/ui/blacklist/editBlacklistEntry.do")
    public void editBlacklistEntry(@RequestBody(required = true) final BlacklistEntry entry) throws DatabaseException {
        log.debug("editing blacklist entry " + entry.getId());
        this.blacklistManager.editBlacklistEntry(entry);
    }

    @ResponseBody
    @RequestMapping(value = "/ui/blacklist/deleteFromBlacklist.do")
    public void deleteFromBlacklist(@RequestBody(required = true) final int entryId) throws DatabaseException {
        log.debug("deleting blacklist entry " + entryId);
        this.blacklistManager.deleteFromBlacklist(entryId);
    }

	@ResponseBody
	@RequestMapping(value = "/ui/blacklist/getListOfRelationships.do")
	public Set<String> getListOfRelationships() throws DatabaseException {
        return this.blacklistManager.getListOfRelationships();
    }

}
