package eu.dnetlib.openaire.blacklist;

import java.util.List;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.openaire.blacklist.BlacklistManager.IIS_STATUS;
import eu.dnetlib.openaire.blacklist.BlacklistManager.STATUS;

public class BlacklistEntry {


    private int id;
    /**
     * The user who reported the wrong link
     **/
    private String user = "unknown";
    /**
     * A note regarding the reported 'wrong' relationship
     **/
    private String note = "";
    /**
     * The id of the ticket associated to this entry
     **/
    private String ticketId = "unknown";
    /**
     * Provenance of the relationship. 'iis' when the relationship is inferred. 'crosswalk' if it is aggregated. 'claim' if it is a claim.
     **/
    private String provenance;
	/**
	 * Relationship label: 'resultProject_outcome_isProducedBy' for result-project relationships.
	 */
	private String relationship;

    /**
     * The inference module that generated the relationship. 'iis::document_referencedProjects' for result-project relationships. Blank if provenance is not 'iis'.
     **/
    private String iisModule = "";

    /**
     * Status of the report
     **/
    private STATUS status = STATUS.PENDING;
    /**
     * Status of the issue from the pov of IIS. Blank if provenance is not 'iis'.
     **/
    private IIS_STATUS iisStatus = null;

    private String creationDate, lastUpdateDate;

    /**
     * OpenAIRE ids of the objects linked by the 'wrong' relationship
     **/
    private String sourceObject, targetObject;
    /**
     * Type of the source and target objects.
     **/
    private String sourceType, targetType;
    /**
     * If the source or the target are representatives, then the following strings are not empty and contain the json strings with the ids of the merged objects
     **/
    private List<String> originalSourceObjects = Lists.newArrayList(), originalTargetObjects = Lists.newArrayList();

    @Override
    public String toString() {
        Gson gson = new Gson();
        return gson.toJson(this);
    }

	public String getRelationship() {
		return relationship;
	}

	public void setRelationship(final String relationship) {
		this.relationship = relationship;
	}

	public String getSourceType() {
		return sourceType;
	}

    public void setSourceType(final String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTargetType() {
        return targetType;
    }

    public void setTargetType(final String targetType) {
        this.targetType = targetType;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUser() {
        return user;
    }

    public void setUser(final String user) {
        this.user = user;
    }

    public String getNote() {
        return note;
    }

    public void setNote(final String note) {
        this.note = note;
    }

    public String getTicketId() {
        return ticketId;
    }

    public void setTicketId(final String ticketId) {
        this.ticketId = ticketId;
    }

    public String getProvenance() {
        return provenance;
    }

    public void setProvenance(final String provenance) {
        this.provenance = provenance;
    }

    public String getIisModule() {
        return iisModule;
    }

    public void setIisModule(final String iisModule) {
        this.iisModule = iisModule;
    }

    public STATUS getStatus() {
        return status;
    }

    public void setStatus(final STATUS status) {
        this.status = status;
    }

    public IIS_STATUS getIisStatus() {
        return iisStatus;
    }

    public void setIisStatus(final IIS_STATUS iisStatus) {
        this.iisStatus = iisStatus;
    }

    public String getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(final String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastUpdateDate() {
        return lastUpdateDate;
    }

    public void setLastUpdateDate(final String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getSourceObject() {
        return sourceObject;
    }

    public void setSourceObject(final String sourceObject) {
        this.sourceObject = sourceObject;
    }

    public String getTargetObject() {
        return targetObject;
    }

    public void setTargetObject(final String targetObject) {
        this.targetObject = targetObject;
    }

    public List<String> getOriginalSourceObjects() {
        return originalSourceObjects;
    }

    public void setOriginalSourceObjects(final List<String> originalSourceObjects) {
        this.originalSourceObjects = originalSourceObjects;
    }

    public List<String> getOriginalTargetObjects() {
        return originalTargetObjects;
    }

    public void setOriginalTargetObjects(final List<String> originalTargetObjects) {
        this.originalTargetObjects = originalTargetObjects;
    }

}
