/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;

public class VerifyDatasourceJobNode
extends SimpleJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String expectedInterfaceTypologyPrefixes;
    private String expectedCompliancePrefixes;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String compliance;
        String dsId = token.getFullEnv().getAttribute("dataprovider:id");
        String ifaceId = token.getFullEnv().getAttribute("dataprovider:interface");
        ISLookUpService lookupService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        try {
            compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/INTERFACE_EXTRA_FIELD[@name='overriding_compliance']/text()");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@compliance/string()");
        }
        String typology = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@typology/string()");
        this.verifyValue(compliance, this.expectedCompliancePrefixes);
        this.verifyValue(typology, this.expectedInterfaceTypologyPrefixes);
        token.getFullEnv().setAttribute("dataprovider:interface:compliance", compliance);
        if (this.isPending(dsId)) {
            return "validateDs";
        }
        return Arc.DEFAULT_ARC;
    }

    private void verifyValue(String value, String expected) throws Exception {
        if (expected != null && !expected.isEmpty()) {
            for (String s : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)expected)) {
                if (!value.toLowerCase().startsWith(s.toLowerCase())) continue;
                return;
            }
            throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
        }
    }

    private boolean isPending(String id) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//RESOURCE_KIND/@value/string()";
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        return res.trim().equals("PendingRepositoryResources");
    }

    public String getExpectedInterfaceTypologyPrefixes() {
        return this.expectedInterfaceTypologyPrefixes;
    }

    public void setExpectedInterfaceTypologyPrefixes(String expectedInterfaceTypologyPrefixes) {
        this.expectedInterfaceTypologyPrefixes = expectedInterfaceTypologyPrefixes;
    }

    public String getExpectedCompliancePrefixes() {
        return this.expectedCompliancePrefixes;
    }

    public void setExpectedCompliancePrefixes(String expectedCompliancePrefixes) {
        this.expectedCompliancePrefixes = expectedCompliancePrefixes;
    }
}

