/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.util.List;
import javax.annotation.Resource;

public class UpdateMetaWfStatusJobNode
extends SimpleJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String metaWfId = token.getFullEnv().getAttribute("META_WORKFLOW_ID");
        String dsId = token.getFullEnv().getAttribute("dataprovider:id");
        String ifaceId = token.getFullEnv().getAttribute("dataprovider:interface");
        this.updateDatasource(dsId, ifaceId);
        if (this.isReady(metaWfId)) {
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(metaWfId, "//CONFIGURATION/@status", "'" + (Object)((Object)WorkflowsConstants.WorkflowStatus.EXECUTABLE) + "'");
        }
        return Arc.DEFAULT_ARC;
    }

    protected void updateDatasource(String dsId, String ifaceId) throws Exception {
        ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(dsId, "//INTERFACE[@id = '" + ifaceId + "']/@active", "'true'");
    }

    private boolean isReady(String metaWfId) throws Exception {
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value eq '" + metaWfId + "']//WORKFLOW/@id for $y in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $y//RESOURCE_IDENTIFIER/@value = $x return $y//PARAM[@required='true' and string-length(text()) = 0]/@managedBy/string()";
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
        if (list.contains("system")) {
            throw new MSROException("A system param is missing in profile: " + metaWfId);
        }
        return list.isEmpty();
    }
}

