/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.is;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateProfilesJobNode
extends SimpleJobNode
implements ProgressJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private int total = 0;
    private int current = 0;
    private static final Log log = LogFactory.getLog(ValidateProfilesJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        int invalidTotals = 0;
        List list = lookup.listResourceTypes();
        this.total = list.size();
        this.current = 0;
        for (String resourceType : list) {
            int valid = 0;
            int invalid = 0;
            String schemaSource = lookup.getResourceTypeSchema(resourceType);
            Schema schema = schemaFactory.newSchema(new StreamSource(new StringReader(schemaSource)));
            Validator validator = schema.newValidator();
            for (String profile : lookup.quickSearchProfile("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='" + resourceType + "']")) {
                try {
                    validator.validate(new StreamSource(new StringReader(profile)));
                    ++valid;
                }
                catch (Exception e) {
                    ++invalid;
                }
            }
            invalidTotals += invalid;
            String message = String.format("Valid: %s, Invalid: %s, Total: %s", valid, invalid, valid + invalid);
            token.getEnv().setAttribute("mainlog:" + resourceType, message);
            log.info((Object)("Validation of " + resourceType + " profiles: " + message));
        }
        if (invalidTotals > 0) {
            throw new MSROException("Validation wf has found " + invalidTotals + " invalid profiles");
        }
        return Arc.DEFAULT_ARC;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            @Override
            public boolean isInaccurate() {
                return false;
            }

            @Override
            public int getTotalValue() {
                return ValidateProfilesJobNode.this.total;
            }

            @Override
            public int getCurrentValue() {
                return ValidateProfilesJobNode.this.current;
            }
        };
    }
}

