/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.info;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MDStoreToApiExtraFieldJobNode
extends SimpleJobNode {
    private String mdId;
    private String datasourceId;
    private String datasourceInterface;
    private String extraFieldForTotal;
    private String extraFieldForDate;
    private String extraFieldForMdId;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;
    private static final Log log = LogFactory.getLog(MDStoreToApiExtraFieldJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        String xq = "for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='" + this.mdId + "' return concat($x//NUMBER_OF_RECORDS, ' @=@ ', $x//LAST_STORAGE_DATE)";
        String s = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xq);
        String[] arr = s.split(" @=@ ");
        int size = NumberUtils.toInt((String)arr[0].trim(), (int)0);
        Date date = new DateUtils().parse(arr[1]);
        if (this.extraFieldForTotal.equals("last_collection_total")) {
            this.dsManager.setLastCollectionInfo(this.datasourceId, this.datasourceInterface, this.mdId, Integer.valueOf(size), date);
        } else if (this.extraFieldForTotal.equals("last_aggregation_total")) {
            this.dsManager.setLastAggregationInfo(this.datasourceId, this.datasourceInterface, this.mdId, Integer.valueOf(size), date);
        } else {
            log.warn((Object)("Invalid field for total: " + this.extraFieldForTotal));
        }
        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getExtraFieldForTotal() {
        return this.extraFieldForTotal;
    }

    public void setExtraFieldForTotal(String extraFieldForTotal) {
        this.extraFieldForTotal = extraFieldForTotal;
    }

    public String getExtraFieldForDate() {
        return this.extraFieldForDate;
    }

    public void setExtraFieldForDate(String extraFieldForDate) {
        this.extraFieldForDate = extraFieldForDate;
    }

    public String getExtraFieldForMdId() {
        return this.extraFieldForMdId;
    }

    public void setExtraFieldForMdId(String extraFieldForMdId) {
        this.extraFieldForMdId = extraFieldForMdId;
    }
}

