/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.oai.OaiIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Required;

public class OaiCollectorPlugin
extends AbstractCollectorPlugin {
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";
    private OaiIteratorFactory oaiIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String mdFormat = (String)interfaceDescriptor.getParams().get(FORMAT_PARAM);
        String setParam = (String)interfaceDescriptor.getParams().get(OAI_SET_PARAM);
        ArrayList sets = Lists.newArrayList();
        if (setParam != null) {
            sets.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)setParam)));
        }
        if (sets.isEmpty()) {
            sets.add("");
        }
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new CollectorServiceException("Param 'mdFormat' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}") && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD or YYYY-MM-DDTHH:MM:SSZ): " + fromDate);
        }
        if (untilDate != null && !untilDate.matches("\\d{4}-\\d{2}-\\d{2}") && !untilDate.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD or YYYY-MM-DDTHH:MM:SSZ): " + untilDate);
        }
        return () -> Iterators.concat(sets.stream().map(set -> this.oaiIteratorFactory.newIterator(baseUrl, mdFormat, (String)set, fromDate, untilDate)).iterator());
    }

    public OaiIteratorFactory getOaiIteratorFactory() {
        return this.oaiIteratorFactory;
    }

    @Required
    public void setOaiIteratorFactory(OaiIteratorFactory oaiIteratorFactory) {
        this.oaiIteratorFactory = oaiIteratorFactory;
    }
}

