/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(FileSystemIterator.class);
    private Set<String> extensions = Sets.newHashSet();
    private Iterator<Path> pathIterator;
    private String current;
    private boolean incremental = false;
    private LocalDate fromDate = null;
    private final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());

    public FileSystemIterator(String baseDir, String extensions) {
        this(baseDir, extensions, null);
    }

    public FileSystemIterator(String baseDir, String extensions, String fromDate) {
        if (StringUtils.isNotBlank((CharSequence)extensions)) {
            this.extensions = Sets.newHashSet((Object[])extensions.split(","));
        }
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = LocalDate.parse(fromDate, this.simpleDateTimeFormatter);
            log.debug((Object)("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString()));
        }
        try {
            this.pathIterator = Files.newDirectoryStream(Paths.get(baseDir, new String[0])).iterator();
            this.current = this.walkTillNext();
        }
        catch (Exception e) {
            log.error((Object)("Cannot initialize File System Iterator. Is this path correct? " + baseDir));
            e.printStackTrace();
            throw new CollectorServiceRuntimeException("Filesystem collection error.", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public synchronized String next() {
        String pivot = new String(this.current);
        this.current = this.walkTillNext();
        log.debug((Object)("Returning: " + pivot));
        return pivot;
    }

    @Override
    public void remove() {
    }

    private synchronized String walkTillNext() {
        while (this.pathIterator.hasNext()) {
            Path nextFilePath = this.pathIterator.next();
            if (Files.isDirectory(nextFilePath, new LinkOption[0])) {
                try {
                    this.pathIterator = Iterators.concat(this.pathIterator, Files.newDirectoryStream(nextFilePath).iterator());
                    log.debug((Object)("Adding folder iterator: " + nextFilePath.toString()));
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)("Cannot create folder iterator! Is this path correct? " + nextFilePath.toString()));
                    return null;
                }
            }
            if (!this.extensions.isEmpty() && !this.extensions.contains(FilenameUtils.getExtension((String)nextFilePath.toString()))) continue;
            if (this.incremental) {
                try {
                    FileTime lastModifiedTime = Files.getLastModifiedTime(nextFilePath, new LinkOption[0]);
                    if (lastModifiedTime.toInstant().isAfter(this.fromDate.atStartOfDay().toInstant(ZoneOffset.UTC))) {
                        log.debug((Object)("Returning: " + nextFilePath.toString()));
                        return nextFilePath.toString();
                    }
                    log.debug((Object)("File " + nextFilePath.toString() + " has not changed."));
                    continue;
                }
                catch (Exception e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
            }
            log.debug((Object)("Returning: " + nextFilePath.toString()));
            return nextFilePath.toString();
        }
        return null;
    }
}

