ALTER TABLE dsm_organizations ADD COLUMN registered_funder boolean;

CREATE VIEW funders_view AS SELECT
	o.id                AS id, 
	o.legalshortname    AS legalshortname,
	o.legalname         AS legalname,
	o.websiteurl        AS websiteurl, 
	o.logourl           AS logourl, 
	o.country           AS country,
	o.dateofcollection  AS registrationdate,
	o.registered_funder AS registered,
	array_agg(DISTINCT s.id||' @=@ '||s.officialname||' @=@ '||s.eosc_datasource_type) AS datasources,
	array_agg(DISTINCT pids.issuertype||' @=@ '||pids.pid) AS pids
FROM 
	dsm_organizations o 
	JOIN dsm_service_organization so           ON (o.id = so.organization) 
	JOIN dsm_services s                        ON (so.service = s.id) 
	JOIN projects p                            ON (p.collectedfrom = s.id)
	LEFT OUTER JOIN dsm_organizationpids opids ON (o.id = opids.organization)
	LEFT OUTER JOIN dsm_identities pids        ON (opids.pid = pids.pid)
GROUP BY o.id;

GRANT ALL ON funders_view TO dnetapi;


