/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationInfo;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationStage;
import eu.dnetlib.openaire.funders.FunderRepository;
import eu.dnetlib.openaire.funders.domain.db.FunderDatasource;
import eu.dnetlib.openaire.funders.domain.db.FunderDbEntry;
import eu.dnetlib.openaire.funders.domain.db.FunderPid;
import java.io.File;
import java.io.FileWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.funders"}, havingValue="true")
public class FunderService {
    private static final String TEMP_FILE_SUFFIX = ".funds.tmp";
    private static final String SEPARATOR = "@=@";
    @Autowired
    private FunderRepository funderRepository;
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    private File tempDir;
    private File tempFile;
    private final DateTimeFormatter DATEFORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Log log = LogFactory.getLog(FunderService.class);

    @PostConstruct
    public void init() {
        this.tempDir = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        for (File f : this.tempDir.listFiles((dir, name) -> name.endsWith(TEMP_FILE_SUFFIX))) {
            this.deleteFile(f);
        }
        new Thread(() -> this.updateFunders()).start();
    }

    private void deleteFile(File f) {
        if (f != null && f.exists()) {
            log.info((Object)("Deleting file: " + f.getAbsolutePath()));
            f.delete();
        }
    }

    @Scheduled(cron="${openaire.exporter.funders.cron}")
    public void updateFunders() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            File tmp = File.createTempFile("funders-api-", TEMP_FILE_SUFFIX, this.tempDir);
            log.info((Object)("Generating funders file: " + tmp.getAbsolutePath()));
            try (FileWriter writer = new FileWriter(tmp);){
                writer.write("[");
                boolean first = true;
                for (FunderDbEntry funder : this.funderRepository.findAll()) {
                    log.info((Object)("  - adding: " + funder.getId()));
                    List datasources = Arrays.stream(funder.getDatasourcesPostgres()).filter(Objects::nonNull).map(s -> s.split(SEPARATOR)).filter(arr -> ((String[])arr).length == 3).map(arr -> {
                        FunderDatasource ds = new FunderDatasource();
                        ds.setId(arr[0].trim());
                        ds.setName(arr[1].trim());
                        ds.setType(arr[2].trim());
                        return ds;
                    }).filter(ds -> StringUtils.isNotBlank((CharSequence)ds.getId())).collect(Collectors.toList());
                    funder.setDatasources(datasources);
                    List pids = Arrays.stream(funder.getPidsPostgres()).filter(Objects::nonNull).map(s -> s.split(SEPARATOR)).filter(arr -> ((String[])arr).length == 2).map(arr -> {
                        FunderPid pid = new FunderPid();
                        pid.setType(arr[0].trim());
                        pid.setValue(arr[1].trim());
                        return pid;
                    }).filter(pid -> StringUtils.isNotBlank((CharSequence)pid.getValue())).collect(Collectors.toList());
                    funder.setPids(pids);
                    this.addAggregationHistory(funder);
                    if (first) {
                        first = false;
                    } else {
                        writer.write(",");
                    }
                    writer.write(mapper.writeValueAsString((Object)funder));
                }
                writer.write("]");
                log.info((Object)("Publish funders file: " + tmp.getAbsolutePath()));
                this.deleteFile(this.tempFile);
                this.setTempFile(tmp);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error generating funders file", e);
            throw new RuntimeException("Error generating funders file", e);
        }
    }

    private void addAggregationHistory(FunderDbEntry funder) {
        List dates = funder.getDatasources().stream().map(FunderDatasource::getId).map(id -> {
            try {
                return this.mongoLoggerClient.getAggregationHistoryV2(id);
            }
            catch (DsmApiException e) {
                log.error((Object)"Error retrieving the aggregation history", (Throwable)e);
                throw new RuntimeException("Error retrieving the aggregation history", e);
            }
        }).flatMap(Collection::stream).filter(AggregationInfo::isCompletedSuccessfully).filter(info -> info.getAggregationStage() == AggregationStage.TRANSFORM).map(AggregationInfo::getDate).distinct().map(s -> LocalDate.parse(s, this.DATEFORMATTER)).sorted(Comparator.reverseOrder()).limit(10L).collect(Collectors.toList());
        funder.setAggregationDates(dates);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }
}

