/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityOpenAIRECommunities;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class CommunityApiController
extends AbstractExporterController {
    @Autowired
    private CommunityService communityService;

    @RequestMapping(value={"/community/communities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get all community profiles", description="get all community profiles", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        try {
            return this.communityService.listCommunities();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="add a new community profile", description="add a new community profile", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@RequestBody CommunityDetails details) throws CommunityException {
        try {
            return this.communityService.newCommunity(details);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get community profile", description="get community profile", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="update community details", description="update community details", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void setCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException {
        try {
            this.communityService.setCommunity(id, properties);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="delete a community", description="delete a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean recursive) throws CommunityException {
        try {
            this.communityService.deleteCommunity(id, recursive);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/projects/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get community projects", description="get community projects", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Page<CommunityProject> getCommunityProjects(@PathVariable String id, @PathVariable Integer page, @PathVariable Integer size, @RequestParam(required=false) String funder, @RequestParam(required=false) String searchFilter, @RequestParam(required=false) String orderBy) throws CommunityException {
        try {
            return this.communityService.getCommunityProjects(id, funder, searchFilter, page.intValue(), size.intValue(), orderBy);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a project to the community", description="associate a project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException {
        try {
            return this.communityService.addCommunityProject(id, project);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a project from the community", description="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProject(@PathVariable String id, @RequestParam String projectId) throws CommunityException {
        try {
            this.communityService.removeCommunityProjects(id, new String[]{projectId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/projectList"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a list of project to the community", description="associate a list of project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject[] addCommunityProjectList(@PathVariable String id, @RequestBody CommunityProject[] projects) throws CommunityException {
        try {
            this.communityService.addCommunityProjects(id, projects);
            return projects;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/projectList"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a list of projects from the community", description="remove a list of projects from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProjectList(@PathVariable String id, @RequestBody String[] projectIdList) throws CommunityException {
        try {
            this.communityService.removeCommunityProjects(id, projectIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/funders"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the funders of the projects of a community", description="get the funders of the projects of a community", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> getCommunityFunders(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunityFunders(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of content providers associated to a given community", description="get the list of content providers associated to a given community", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityContentproviders(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunityContentproviders(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a content provider to the community", description="associate a content provider to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityContentprovider(@PathVariable String id, @RequestBody CommunityContentprovider contentprovider) throws CommunityException {
        try {
            this.communityService.addCommunityContentProviders(id, new CommunityContentprovider[]{contentprovider});
            return contentprovider;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the association between a content provider and the community", description="remove the association between a content provider and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityContentprovider(@PathVariable String id, @RequestParam String contentproviderId) throws CommunityException {
        try {
            this.communityService.removeCommunityContentProviders(id, new String[]{contentproviderId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/contentprovidersList"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a list of content providers to the community", description="associate a list of content providers to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider[] addCommunityContentProvidersList(@PathVariable String id, @RequestBody CommunityContentprovider[] contentprovidersList) throws CommunityException {
        try {
            this.communityService.addCommunityContentProviders(id, contentprovidersList);
            return contentprovidersList;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/contentprovidersList"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a list of content providers from the community", description="remove a list of content providers from the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityContentProvidersList(@PathVariable String id, @RequestBody String[] contentProviderIdList) throws CommunityException {
        try {
            this.communityService.removeCommunityContentProviders(id, contentProviderIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of organizations for a given community", description="get the list of organizations for a given community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityOrganization> getCommunityOrganizations(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunityOrganizations(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate an organization to the community", description="associate an organization to the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization addCommunityOrganization(@PathVariable String id, @RequestBody CommunityOrganization organization) throws CommunityException {
        try {
            this.communityService.addCommunityOrganizations(id, new CommunityOrganization[]{organization});
            return organization;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/organizationList"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a list of organizations to the community", description="associate a list of organizations to the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization[] addCommunityOrganizationList(@PathVariable String id, @RequestBody CommunityOrganization[] orgs) throws CommunityException {
        try {
            this.communityService.addCommunityOrganizations(id, orgs);
            return orgs;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the association between an organization and the community", description="remove the association between an organization and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganization(@PathVariable String id, @RequestParam String organizationName) throws CommunityException {
        try {
            this.communityService.removeCommunityOrganizations(id, new String[]{organizationName});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/organizationList"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a list of associations between some organizations and the community", description="remove a list of associations between some organizations and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganizationList(@PathVariable String id, @RequestBody String[] orgNames) throws CommunityException {
        try {
            this.communityService.removeCommunityOrganizations(id, orgNames);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a subject to the community", description="associate a subject to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunitySubjects(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove subjects from a community", description="remove subjects from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunitySubjects(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/fos"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a fos to the community", description="associate a fos to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunityFOS(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/fos"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove fos from a community", description="remove fos from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunityFOS(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/sdg"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a sdg to the community", description="associate a sdg to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunitySDG(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/sdg"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove sdg from a community", description="remove sdg from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunitySDG(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/advancedConstraint"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="the set of constraints to be used to extend the association between result and community", description="the set of constraints to be used to extend the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addAdvancedConstraint(@PathVariable String id, @RequestBody SelectionCriteria advancedConstraint) throws CommunityException {
        try {
            return this.communityService.addCommunityAdvancedConstraint(id, advancedConstraint);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/advancedConstraint"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the constraints to extend the association result community from a community", description="remove the constraints to extend the association result community from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeAdvancedConstraint(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.removeCommunityAdvancedConstraint(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/removeConstraint"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="the set of constraints to be used to remove the association between result and community", description="the set of constraints to be used to remove the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addRemoveConstraint(@PathVariable String id, @RequestBody SelectionCriteria removeConstraint) throws CommunityException {
        try {
            return this.communityService.addCommunityRemoveConstraint(id, removeConstraint);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/removeConstraint"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the constraints to remove the association beetween result and community", description="remove the constraints to remove the association beetween result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeRemoveConstraint(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.removeCommunityRemoveConstraint(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a Zenodo community to the community", description="associate a Zenodo community to the community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        try {
            return this.communityService.addCommunityZenodoCommunity(id, zenodocommunity, main);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a Zenodo community from a community", description="remove a Zenodo community from a community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        try {
            this.communityService.removeCommunityZenodoCommunity(id, zenodocommunity, main);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{zenodoId}/openairecommunities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of OpenAIRE communities associated to a given Zenodo community", description="get the list of OpenAIRE communities associated to a given Zenodo community", tags={"Community Zenodo Communities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOpenAIRECommunities getOpenAireCommunities(@PathVariable String zenodoId) throws CommunityException {
        try {
            CommunityOpenAIRECommunities res = new CommunityOpenAIRECommunities();
            res.setZenodoid(zenodoId);
            res.setOpenAirecommunitylist(this.communityService.getOpenAIRECommunitiesByZenodoId(zenodoId));
            return res;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/propagationOrganizationCommunityMap"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="Get the propagationOrganizationCommunityMap", description="propagationOrganizationCommunityMap", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Map<String, Set<String>> getPropagationOrganizationCommunityMap() throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationCommunityMap();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/propagationOrganizations"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="try { return the propagation organizations of a community", description="try { return the propagation organizations of a community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> getPropagationOrganizationsForCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationsForCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/propagationOrganizations"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="add an organization to the propagationOrganizationCommunityMap", description="add an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> addPropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.addPropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/propagationOrganizations"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="delete an organization to the propagationOrganizationCommunityMap", description="delete an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> removePropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.removePropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subcommunities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of subcommunities for a given community", description="get the list of subcommunities for a given community", tags={"Subcommunities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<SubCommunity> getSubCommunities(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean all) throws CommunityException {
        try {
            return this.communityService.getSubCommunities(id).stream().filter(sc -> all || sc.isBrowsable()).collect(Collectors.toList());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subcommunities"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a subcommunity to the community", description="associate a subcommunity to the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunity(@PathVariable String id, @RequestBody SubCommunity subcommunity) throws CommunityException {
        try {
            this.communityService.addSubCommunities(id, new SubCommunity[]{subcommunity});
            return subcommunity;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subcommunitiesList"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a list of subcommunities to the community", description="associate a list of subcommunities to the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity[] addSubCommunityList(@PathVariable String id, @RequestBody SubCommunity[] subcommunities) throws CommunityException {
        try {
            this.communityService.addSubCommunities(id, subcommunities);
            return subcommunities;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subcommunities"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the association between a subcommunity and the community", description="remove the association between a subcommunity and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubCommunity(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        try {
            this.communityService.removeSubCommunities(id, new String[]{subCommunityId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @RequestMapping(value={"/community/{id}/subcommunitiesList"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a list of associations between some subcommunities and the community", description="remove a list of associations between some subcommunities and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubcommunities(@PathVariable String id, @RequestBody String[] subCommunityIdList) throws CommunityException {
        try {
            this.communityService.removeSubCommunities(id, subCommunityIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }
}

