/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityClient;
import eu.dnetlib.openaire.community.CommunityCommon;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityMappingUtils;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunityOpenAIRECommunities;
import eu.dnetlib.openaire.community.CommunityOrganization;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityWritableProperties;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import eu.dnetlib.openaire.context.Concept;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
public class CommunityApiCore {
    private static final Log log = LogFactory.getLog(CommunityApiCore.class);
    @Autowired
    private CommunityClient cci;
    @Autowired
    private ISClient isClient;
    @Autowired
    private CommunityCommon cc;

    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.cc.listCommunities();
    }

    public CommunityDetails getCommunity(String id) throws CommunityException, CommunityNotFoundException {
        return this.cc.getCommunity(id);
    }

    public void setCommunity(String id, CommunityWritableProperties details) throws CommunityException, CommunityNotFoundException {
        this.cc.getCommunity(id);
        if (details.getShortName() != null) {
            this.isClient.updateContextAttribute(id, "label", details.getShortName());
        }
        if (details.getName() != null) {
            this.isClient.updateContextParam(id, "name", details.getName());
        }
        if (details.getDescription() != null) {
            this.isClient.updateContextParam(id, "description", details.getDescription());
        }
        if (details.getLogoUrl() != null) {
            this.isClient.updateContextParam(id, "logourl", details.getLogoUrl());
        }
        if (details.getStatus() != null) {
            this.isClient.updateContextParam(id, "status", details.getStatus().name());
        }
        if (details.getSubjects() != null) {
            this.isClient.updateContextParam(id, "subject", Joiner.on((String)",").join((Iterable)details.getSubjects()));
        }
        if (details.getMainZenodoCommunity() != null) {
            this.isClient.updateContextParam(id, "zenodoCommunity", details.getMainZenodoCommunity());
        }
        this.cc.updateCommunity(id, details);
    }

    public List<CommunityProject> getCommunityProjects(String id) throws CommunityException, CommunityNotFoundException {
        this.cc.getCommunity(id);
        return this.cc.getCommunityInfo(id, "::projects", c -> CommunityMappingUtils.asCommunityProject((String)id, (Concept)c));
    }

    public CommunityProject addCommunityProject(String id, CommunityProject project) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)project.getCommunityId())) {
            throw new CommunityException("parameters 'id' and project.communityId must be coherent");
        }
        TreeMap projects = this.getCommunityProjectMap(id);
        String project_id = project.getId();
        if (project_id != null && projects.keySet().contains(Integer.valueOf(project_id))) {
            if (project.getName() != null) {
                this.isClient.updateConceptParam(id + "::projects" + "::" + project_id, "projectfullname", project.getName());
            }
            if (project.getAcronym() != null) {
                this.isClient.updateConceptParam(id + "::projects" + "::" + project_id, "acronym", project.getAcronym());
            }
            if (project.getOpenaireId() != null) {
                this.isClient.updateConceptParam(id + "::projects" + "::" + project_id, "openaireId", project.getOpenaireId());
            }
            if (project.getFunder() != null) {
                this.isClient.updateConceptParam(id + "::projects" + "::" + project_id, "funder", project.getFunder());
            }
            if (project.getGrantId() != null) {
                this.isClient.updateConceptParam(id + "::projects" + "::" + project_id, "CD_PROJECT_NUMBER", project.getGrantId());
            }
        } else {
            project.setId(this.nextId(projects != null && !projects.isEmpty() ? (Integer)projects.lastKey() : Integer.valueOf(0)));
            this.isClient.addConcept(id, id + "::projects", CommunityMappingUtils.asProjectXML((String)id, (CommunityProject)project));
        }
        this.cc.updateProject(id, project);
        return project;
    }

    private String nextId(Integer id) {
        return String.valueOf(id + 1);
    }

    public void removeCommunityProject(String id, Integer projectId) throws CommunityException, CommunityNotFoundException {
        TreeMap projects = this.getCommunityProjectMap(id);
        if (!projects.containsKey(projectId)) {
            throw new CommunityNotFoundException(String.format("project '%s' doesn't exist within context '%s'", projectId, id));
        }
        this.isClient.removeConcept(id, id + "::projects", id + "::projects" + "::" + projectId);
        this.cc.removeFromCategory(id, "::projects", String.valueOf(projectId));
    }

    public List<CommunityContentprovider> getCommunityContentproviders(String id) throws CommunityException, CommunityNotFoundException {
        this.cc.getCommunity(id);
        return this.cc.getCommunityInfo(id, "::contentproviders", c -> CommunityMappingUtils.asCommunityDataprovider((String)id, (Concept)c));
    }

    public CommunityContentprovider addCommunityContentprovider(String id, CommunityContentprovider cp) throws CommunityException, CommunityNotFoundException {
        log.info((Object)("content provider to add " + cp.toString()));
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)cp.getCommunityId())) {
            throw new CommunityException("parameters 'id' and cp.communityId must be coherent");
        }
        TreeMap cps = this.getCommunityContentproviderMap(id);
        String concept_id = cp.getId();
        if (concept_id != null && cps.keySet().contains(Integer.valueOf(concept_id))) {
            if (cp.getName() != null) {
                this.isClient.updateConceptParam(id + "::contentproviders" + "::" + concept_id, "name", cp.getName());
            }
            if (cp.getOfficialname() != null) {
                this.isClient.updateConceptParam(id + "::contentproviders" + "::" + concept_id, "officialname", cp.getOfficialname());
            }
            if (cp.getOpenaireId() != null) {
                this.isClient.updateConceptParam(id + "::contentproviders" + "::" + concept_id, "openaireId", cp.getOpenaireId());
            }
            if (cp.getSelectioncriteria() != null) {
                this.isClient.updateConceptParamNoEscape(id + "::contentproviders" + "::" + concept_id, "selcriteria", cp.toXML());
            }
        } else {
            log.info((Object)("adding new concept for community " + id));
            cp.setId(this.nextId(!cps.isEmpty() ? (Integer)cps.lastKey() : Integer.valueOf(0)));
            this.isClient.addConcept(id, id + "::contentproviders", CommunityMappingUtils.asContentProviderXML((String)id, (CommunityContentprovider)cp));
        }
        this.cc.updateDatasource(id, cp);
        return cp;
    }

    public void removeCommunityContentProvider(String id, Integer contentproviderId) throws CommunityException, CommunityNotFoundException {
        TreeMap providers = this.getCommunityContentproviderMap(id);
        if (!providers.containsKey(contentproviderId)) {
            throw new CommunityNotFoundException(String.format("content provider '%s' doesn't exist within context '%s'", contentproviderId, id));
        }
        this.isClient.removeConcept(id, id + "::contentproviders", id + "::contentproviders" + "::" + contentproviderId);
        this.cc.removeFromCategory(id, "::contentproviders", String.valueOf(contentproviderId));
    }

    public void removeCommunityOrganization(String id, Integer organizationId) throws CommunityException, CommunityNotFoundException {
        TreeMap organizations = this.getCommunityOrganizationMap(id);
        if (!organizations.containsKey(organizationId)) {
            throw new CommunityNotFoundException(String.format("organization '%s' doesn't exist within context '%s'", organizationId, id));
        }
        this.isClient.removeConcept(id, id + "::organizations", id + "::organizations" + "::" + organizationId);
        this.cc.removeFromCategory(id, "::organizations", String.valueOf(organizationId));
    }

    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(String id) throws CommunityException, CommunityNotFoundException {
        return this.cc.getCommunityZenodoCommunities(id);
    }

    public List<CommunityOrganization> getCommunityOrganizations(String id) throws CommunityException, CommunityNotFoundException {
        this.cc.getCommunity(id);
        return this.cc.getCommunityInfo(id, "::organizations", c -> CommunityMappingUtils.asCommunityOrganization((String)id, (Concept)c));
    }

    public CommunityDetails addCommunitySubjects(String id, List<String> subjects) throws CommunityException, CommunityNotFoundException {
        CommunityDetails cd = new CommunityDetails();
        HashSet current = Sets.newHashSet((Iterable)this.cc.getCommunity(id).getSubjects());
        current.addAll(subjects);
        cd.setSubjects((List)Lists.newArrayList((Iterable)current));
        this.setCommunity(id, CommunityWritableProperties.fromDetails((CommunityDetails)cd));
        return cd;
    }

    public CommunityDetails removeCommunitySubjects(String id, List<String> subjects) throws CommunityException, CommunityNotFoundException {
        CommunityDetails cd = new CommunityDetails();
        HashSet current = Sets.newHashSet((Iterable)this.cc.getCommunity(id).getSubjects());
        current.removeAll(subjects);
        cd.setSubjects((List)Lists.newArrayList((Iterable)current));
        this.setCommunity(id, CommunityWritableProperties.fromDetails((CommunityDetails)cd));
        return cd;
    }

    @CacheEvict(value={"community-cache"}, allEntries=true)
    public void removeCommunityZenodoCommunity(String id, Integer zenodoCommId) throws CommunityException, CommunityNotFoundException {
        TreeMap zcomms = this.getZenodoCommunityMap(id);
        if (!zcomms.containsKey(zenodoCommId)) {
            throw new CommunityNotFoundException(String.format("Zenodo community '%s' doesn't exist within context '%s'", zenodoCommId, id));
        }
        this.isClient.removeConcept(id, id + "::zenodocommunities", id + "::zenodocommunities" + "::" + zenodoCommId);
        this.cc.removeFromCategory(id, "::zenodocommunities", String.valueOf(zenodoCommId));
    }

    @CacheEvict(value={"community-cache"}, allEntries=true)
    public CommunityZenodoCommunity addCommunityZenodoCommunity(String id, CommunityZenodoCommunity zc) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)zc.getCommunityId())) {
            throw new CommunityException("parameters 'id' and zc.communityId must be coherent");
        }
        if (!StringUtils.isNotBlank((CharSequence)zc.getZenodoid())) {
            throw new CommunityException("parameter zenodoid cannot be null or empty");
        }
        TreeMap zcs = this.getZenodoCommunityMap(id);
        for (CommunityZenodoCommunity czc : zcs.values()) {
            if (!czc.getZenodoid().equals(zc.getZenodoid())) continue;
            throw new CommunityException("Zenodo community already associated to the RCD");
        }
        zc.setId(this.nextId(!zcs.isEmpty() ? (Integer)zcs.lastKey() : Integer.valueOf(0)));
        this.isClient.addConcept(id, id + "::zenodocommunities", CommunityMappingUtils.asZenodoCommunityXML((String)id, (CommunityZenodoCommunity)zc));
        this.cc.updateZenodoCommunity(id, zc);
        return zc;
    }

    public CommunityOpenAIRECommunities getOpenAIRECommunities(String zenodoId) throws CommunityException, CommunityNotFoundException {
        if (this.cci.getInverseZenodoCommunityMap().containsKey(zenodoId)) {
            return new CommunityOpenAIRECommunities().setZenodoid(zenodoId).setOpenAirecommunitylist(((Set)this.cci.getInverseZenodoCommunityMap().get(zenodoId)).stream().collect(Collectors.toList()));
        }
        return new CommunityOpenAIRECommunities();
    }

    private TreeMap<Integer, CommunityProject> getCommunityProjectMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityProjects(id).stream().collect(Collectors.toMap(p -> Integer.valueOf(p.getId()), Functions.identity(), (p1, p2) -> {
            log.warn((Object)String.format("duplicate project found: '%s'", p1.getId()));
            return p2;
        }, TreeMap::new));
    }

    private TreeMap<Integer, CommunityContentprovider> getCommunityContentproviderMap(String id) throws CommunityException, CommunityNotFoundException {
        log.info((Object)"getting community content provider map");
        return this.getCommunityContentproviders(id).stream().collect(Collectors.toMap(cp -> Integer.valueOf(cp.getId()), Functions.identity(), (cp1, cp2) -> {
            log.warn((Object)String.format("duplicate content provider found: '%s'", cp1.getId()));
            return cp2;
        }, TreeMap::new));
    }

    private TreeMap<Integer, CommunityZenodoCommunity> getZenodoCommunityMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityZenodoCommunities(id).stream().collect(Collectors.toMap(cp -> Integer.valueOf(cp.getId()), Functions.identity(), (cp1, cp2) -> {
            log.warn((Object)String.format("duplicate Zenodo community found: '%s'", cp1.getId()));
            return cp2;
        }, TreeMap::new));
    }

    private TreeMap<Integer, CommunityOrganization> getCommunityOrganizationMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityOrganizations(id).stream().collect(Collectors.toMap(o -> Integer.valueOf(o.getId()), Functions.identity(), (o1, o2) -> {
            log.warn((Object)String.format("duplicate content provider found: '%s'", o1.getId()));
            return o2;
        }, TreeMap::new));
    }

    public CommunityOrganization addCommunityOrganization(String id, CommunityOrganization organization) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)organization.getCommunityId())) {
            throw new CommunityException("parameters 'id' and organization.communityId must be coherent");
        }
        TreeMap cps = this.getCommunityOrganizationMap(id);
        String organization_id = organization.getId();
        if (organization_id != null && cps.keySet().contains(Integer.valueOf(organization_id))) {
            if (organization.getName() != null) {
                this.isClient.updateConceptParam(id + "::organizations" + "::" + organization_id, "name", organization.getName());
            }
            if (organization.getLogo_url() != null) {
                this.isClient.updateConceptParam(id + "::organizations" + "::" + organization_id, "logourl", Base64.getEncoder().encodeToString(organization.getLogo_url().getBytes()));
            }
            if (organization.getWebsite_url() != null) {
                this.isClient.updateConceptParam(id + "::organizations" + "::" + organization_id, "websiteurl", Base64.getEncoder().encodeToString(organization.getWebsite_url().getBytes()));
            }
        } else {
            organization.setId(this.nextId(!cps.isEmpty() ? (Integer)cps.lastKey() : Integer.valueOf(0)));
            this.isClient.addConcept(id, id + "::organizations", CommunityMappingUtils.asOrganizationXML((String)id, (CommunityOrganization)organization));
        }
        this.cc.updateOrganization(id, organization);
        return organization;
    }
}

