/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.community.CommunityApiCore;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunityOpenAIRECommunities;
import eu.dnetlib.openaire.community.CommunityOrganization;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityWritableProperties;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class CommunityApiController {
    @Autowired
    private CommunityApiCore communityApiCore;

    @RequestMapping(value={"/community/communities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get all community profiles", description="get all community profiles", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.communityApiCore.listCommunities();
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get community profile", description="get community profile", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunity(id);
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="update community details", description="update community details", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void setCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.setCommunity(id, properties);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get community projects", description="get community projects", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityProject> getCommunityProjects(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityProjects(id);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a project to the community", description="associate a project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityProject(id, project);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a project from the community", description="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProject(@PathVariable String id, @RequestBody Integer projectId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityProject(id, projectId);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of content providers associated to a given community", description="get the list of content providers associated to a given community", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityContentproviders(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityContentproviders(id);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a content provider to the community", description="associate a content provider to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityContentprovider(@PathVariable String id, @RequestBody CommunityContentprovider contentprovider) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityContentprovider(id, contentprovider);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the association between a content provider and the community", description="remove the association between a content provider and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityContentprovider(@PathVariable String id, @RequestBody Integer contentproviderId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityContentProvider(id, contentproviderId);
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of organizations for a given community", description="get the list of organizations for a given community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityOrganization> getCommunityOrganizations(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityOrganizations(id);
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate an organization to the community", description="associate an organization to the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization addCommunityOrganization(@PathVariable String id, @RequestBody CommunityOrganization organization) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityOrganization(id, organization);
    }

    @RequestMapping(value={"/community/{id}/organizations"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove the association between an organization and the community", description="remove the association between an organization and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganization(@PathVariable String id, @RequestBody Integer organizationId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityOrganization(id, organizationId);
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a subject to the community", description="associate a subject to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySubjects(@PathVariable String id, @RequestBody List<String> subjects) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunitySubjects(id, subjects);
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove subjects from a community", description="remove subjects from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySubjects(@PathVariable String id, @RequestBody List<String> subjects) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.removeCommunitySubjects(id, subjects);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of Zenodo communities associated to a given community", description="get the list of Zenodo communities associated to a given community", tags={"Community Zenodo Communities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityZenodoCommunities(id);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="associate a Zenodo community to the community", description="associate a Zenodo community to the community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityZenodoCommunity addCommunityZenodoCommunity(@PathVariable String id, @RequestBody CommunityZenodoCommunity zenodocommunity) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityZenodoCommunity(id, zenodocommunity);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @Operation(summary="remove a Zenodo community from a community", description="remove a Zenodo community from a community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityZenodoCommunity(@PathVariable String id, @RequestBody Integer zenodoCommId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityZenodoCommunity(id, zenodoCommId);
    }

    @RequestMapping(value={"/community/{zenodoId}/openairecommunities"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of OpenAIRE communities associated to a given Zenodo community", description="get the list of OpenAIRE communities associated to a given Zenodo community", tags={"Community Zenodo Communities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOpenAIRECommunities getOpenAireCommunities(@PathVariable String zenodoId) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getOpenAIRECommunities(zenodoId);
    }
}

