/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.openaire.dsm.dao.VocabularyClient;
import eu.dnetlib.openaire.vocabularies.Vocabulary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class VocabularyClientImpl
implements VocabularyClient {
    private static final Log log = LogFactory.getLog(VocabularyClientImpl.class);
    @Autowired
    private DnetOpenaireExporterProperties config;

    @Cacheable(value={"vocabularies-cache"})
    public Vocabulary getCountries() throws DsmException {
        return (Vocabulary)this._getVocabulary(this.config.getVocabularies().getCountriesEndpoint(), Vocabulary.class);
    }

    @Cacheable(value={"vocabularies-cache"})
    public Vocabulary getDatasourceTypologies() throws DsmException {
        return (Vocabulary)this._getVocabulary(this.config.getVocabularies().getDatasourceTypologiesEndpoint(), Vocabulary.class);
    }

    private <T> T _getVocabulary(String endpoint, Class<T> clazz) throws DsmException {
        RestTemplate rt = new RestTemplate();
        log.info((Object)("get vocabulary from " + endpoint));
        ResponseEntity rsp = rt.getForEntity(endpoint, clazz, new Object[0]);
        if (!rsp.getStatusCode().is2xxSuccessful()) {
            throw new DsmException(rsp.getStatusCodeValue(), "unable to read content from " + endpoint);
        }
        return (T)rsp.getBody();
    }

    @CacheEvict(cacheNames={"vocabularies-cache"}, allEntries=true)
    @Scheduled(fixedDelayString="${openaire.exporter.cache.ttl}")
    public void dropCache() {
        log.debug((Object)"dropped dsManager vocabulary cache");
    }
}

