/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@JsonAutoDetect
public class CommunityWritableProperties {
    @Schema(description="community name")
    private String name;
    @Schema(description="community short name")
    private String shortName;
    @Schema(description="community description")
    private String description;
    @Schema(description="http url for the community logo")
    private String logoUrl;
    @Schema(description="list of subjects (keywords) that characterise this community")
    private List<String> subjects;
    @Schema(description="status of the community, drives its visibility")
    private CommunityStatus status;
    @Schema(description="id of the main Zenodo community")
    private String mainZenodoCommunity;

    public static CommunityWritableProperties fromDetails(CommunityDetails details) {
        CommunityWritableProperties p = new CommunityWritableProperties();
        p.setName(details.getName());
        p.setShortName(details.getShortName());
        p.setDescription(details.getDescription());
        p.setLogoUrl(details.getLogoUrl());
        p.setSubjects(details.getSubjects());
        p.setStatus(details.getStatus());
        p.setMainZenodoCommunity(details.getZenodoCommunity());
        return p;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public CommunityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommunityStatus status) {
        this.status = status;
    }

    public String getMainZenodoCommunity() {
        return this.mainZenodoCommunity;
    }

    public void setMainZenodoCommunity(String mainZenodoCommunity) {
        this.mainZenodoCommunity = mainZenodoCommunity;
    }
}

