/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityConstants;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityMappingUtils;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunityOrganization;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityWritableProperties;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import eu.dnetlib.openaire.context.Category;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.Param;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommunityCommon {
    @Autowired
    private ISClient isClient;

    public Map<String, Context> getContextMap() throws CommunityException {
        try {
            return this.isClient.getCommunityContextMap();
        }
        catch (IOException e) {
            throw new CommunityException(e);
        }
    }

    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.getContextMap().values().stream().filter(context -> !CommunityConstants.communityBlackList.contains(context.getId())).map(CommunityMappingUtils::asCommunitySummary).collect(Collectors.toList());
    }

    public <R> List<R> getCommunityInfo(String id, String idSuffix, Function<Concept, R> mapping) throws CommunityException {
        Map categories;
        Category category;
        Map contextMap = this.getContextMap();
        Context context = (Context)contextMap.get(id);
        if (context != null && (category = (Category)(categories = context.getCategories()).get(id + idSuffix)) != null) {
            return category.getConcepts().stream().map(mapping).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public CommunityDetails getCommunity(String id) throws CommunityException, CommunityNotFoundException {
        Context context = (Context)this.getContextMap().get(id);
        if (context == null || CommunityConstants.communityBlackList.contains(id)) {
            throw new CommunityNotFoundException(String.format("community '%s' does not exist", id));
        }
        return CommunityMappingUtils.asCommunityProfile((Context)context);
    }

    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this.getCommunityInfo(id, "::zenodocommunities", c -> CommunityMappingUtils.asCommunityZenodoCommunity((String)id, (Concept)c));
    }

    public void updateProject(String communityId, CommunityProject project) throws CommunityException {
        Context context = (Context)this.getContextMap().get(communityId);
        Category prj = (Category)context.getCategories().get(communityId + "::projects");
        if (prj.getConcepts().stream().map(c -> c.getId()).collect(Collectors.toList()).contains(communityId + "::projects" + "::" + project.getId())) {
            prj.getConcepts().forEach(concept -> {
                if (concept.getId().equals(communityId + "::projects" + "::" + project.getId())) {
                    if (project.getName() != null) {
                        concept.getParams().replace("projectfullname", Arrays.asList(new Param().setName("projectfullname").setValue(project.getName())));
                    }
                    if (project.getAcronym() != null) {
                        if (concept.getParams().keySet().contains("acronym")) {
                            concept.getParams().replace("acronym", Arrays.asList(new Param().setName("acronym").setValue(project.getAcronym())));
                        } else {
                            concept.getParams().put("acronym", Arrays.asList(new Param().setName("acronym").setValue(project.getAcronym())));
                        }
                    }
                    if (project.getOpenaireId() != null) {
                        if (concept.getParams().keySet().contains("openaireId")) {
                            concept.getParams().replace("openaireId", Arrays.asList(new Param().setName("openaireId").setValue(project.getOpenaireId())));
                        } else {
                            concept.getParams().put("openaireId", Arrays.asList(new Param().setName("openaireId").setValue(project.getOpenaireId())));
                        }
                    }
                    if (project.getFunder() != null) {
                        concept.getParams().replace("funder", Arrays.asList(new Param().setName("funder").setValue(project.getFunder())));
                    }
                    if (project.getGrantId() != null) {
                        concept.getParams().replace("CD_PROJECT_NUMBER", Arrays.asList(new Param().setName("CD_PROJECT_NUMBER").setValue(project.getGrantId())));
                    }
                }
            });
        } else {
            Concept concept2 = new Concept();
            concept2.setId(communityId + "::projects" + "::" + project.getId());
            concept2.setClaim(false);
            if (project.getAcronym() != null) {
                concept2.setLabel(project.getAcronym());
            } else {
                concept2.setLabel("");
            }
            TreeMap<String, List<Param>> params = new TreeMap<String, List<Param>>();
            if (project.getAcronym() != null) {
                params.put("acronym", Arrays.asList(new Param().setName("acronym").setValue(project.getAcronym())));
            }
            if (project.getName() != null) {
                params.put("projectfullname", Arrays.asList(new Param().setName("projectfullname").setValue(project.getName())));
            }
            if (project.getOpenaireId() != null) {
                params.put("openaireId", Arrays.asList(new Param().setName("openaireId").setValue(project.getOpenaireId())));
            }
            if (project.getFunder() != null) {
                params.put("funder", Arrays.asList(new Param().setName("funder").setValue(project.getFunder())));
            }
            if (project.getGrantId() != null) {
                params.put("CD_PROJECT_NUMBER", Arrays.asList(new Param().setName("CD_PROJECT_NUMBER").setValue(project.getGrantId())));
            }
            concept2.setParams(params);
            prj.getConcepts().add(concept2);
        }
    }

    public void updateCommunity(String id, CommunityWritableProperties community) throws CommunityException {
        Context context = (Context)this.getContextMap().get(id);
        if (community.getShortName() != null) {
            context.setLabel(community.getShortName());
        }
        if (community.getName() != null) {
            context.getParams().replace("name", Arrays.asList(new Param().setValue(community.getName()).setName("name")));
        }
        if (community.getDescription() != null) {
            context.getParams().replace("description", Arrays.asList(new Param().setName("description").setValue(community.getDescription())));
        }
        if (community.getLogoUrl() != null) {
            context.getParams().replace("logourl", Arrays.asList(new Param().setName("logourl").setValue(community.getLogoUrl())));
        }
        if (community.getStatus() != null) {
            context.getParams().replace("status", Arrays.asList(new Param().setName("status").setValue(community.getStatus().name())));
        }
        if (community.getSubjects() != null) {
            context.getParams().replace("subject", Arrays.asList(new Param().setName("subject").setValue(Joiner.on((String)",").join((Iterable)community.getSubjects()))));
        }
        if (community.getMainZenodoCommunity() != null) {
            context.getParams().replace("zenodoCommunity", Arrays.asList(new Param().setName("zenodoCommunity").setValue(community.getMainZenodoCommunity())));
        }
    }

    public void removeFromCategory(String communityId, String category, String conceptId) throws CommunityException {
        Map cmap = this.getContextMap();
        Context context = (Context)cmap.get(communityId);
        Map cat = context.getCategories();
        List concepts = ((Category)cat.get(communityId + category)).getConcepts().stream().filter(c -> !c.getId().equals(communityId + category + "::" + conceptId)).collect(Collectors.toList());
        ((Category)cat.get(communityId + category)).setConcepts(concepts);
    }

    public void updateDatasource(String communityId, CommunityContentprovider cp) throws CommunityException {
        Context context = (Context)this.getContextMap().get(communityId);
        Category dts = (Category)context.getCategories().get(communityId + "::contentproviders");
        if (dts.getConcepts().stream().map(c -> c.getId()).collect(Collectors.toList()).contains(communityId + "::contentproviders" + "::" + cp.getId())) {
            dts.getConcepts().forEach(concept -> {
                if (concept.getId().equals(communityId + "::contentproviders" + "::" + cp.getId())) {
                    if (cp.getName() != null) {
                        if (concept.getParams().keySet().contains("name")) {
                            concept.getParams().replace("name", Arrays.asList(new Param().setName("name").setValue(cp.getName())));
                        } else {
                            concept.getParams().put("name", Arrays.asList(new Param().setName("name").setValue(cp.getName())));
                        }
                    }
                    if (cp.getOfficialname() != null) {
                        if (concept.getParams().keySet().contains("officialname")) {
                            concept.getParams().replace("officialname", Arrays.asList(new Param().setName("officialname").setValue(cp.getOfficialname())));
                        } else {
                            concept.getParams().put("officialname", Arrays.asList(new Param().setName("officialname").setValue(cp.getOfficialname())));
                        }
                    }
                    if (cp.getOpenaireId() != null) {
                        if (concept.getParams().keySet().contains("openaireId")) {
                            concept.getParams().replace("openaireId", Arrays.asList(new Param().setName("openaireId").setValue(cp.getOpenaireId())));
                        } else {
                            concept.getParams().put("openaireId", Arrays.asList(new Param().setName("openaireId").setValue(cp.getOpenaireId())));
                        }
                    }
                    if (cp.getSelectioncriteria() != null) {
                        if (concept.getParams().keySet().contains("selcriteria")) {
                            concept.getParams().replace("selcriteria", Arrays.asList(new Param().setName("selcriteria").setValue(cp.toJson())));
                        } else {
                            concept.getParams().put("selcriteria", Arrays.asList(new Param().setName("selcriteria").setValue(cp.toJson())));
                        }
                    }
                }
            });
        } else {
            Concept concept2 = new Concept();
            concept2.setId(communityId + "::contentproviders" + "::" + cp.getId());
            concept2.setClaim(false);
            concept2.setLabel("");
            TreeMap<String, List<Param>> params = new TreeMap<String, List<Param>>();
            if (cp.getName() != null) {
                params.put("name", Arrays.asList(new Param().setValue(cp.getName()).setName("name")));
            }
            if (cp.getOfficialname() != null) {
                params.put("officialname", Arrays.asList(new Param().setValue(cp.getOfficialname()).setName("officialname")));
            }
            if (cp.getOpenaireId() != null) {
                params.put("openaireId", Arrays.asList(new Param().setValue(cp.getOpenaireId()).setName("openaireId")));
            }
            if (cp.getSelectioncriteria() != null) {
                params.put("selcriteria", Arrays.asList(new Param().setValue(cp.toJson()).setName("selcriteria")));
            }
            concept2.setParams(params);
            dts.getConcepts().add(concept2);
        }
    }

    public void updateOrganization(String communityId, CommunityOrganization organization) throws CommunityException {
        Context context = (Context)this.getContextMap().get(communityId);
        Category orgs = (Category)context.getCategories().get(communityId + "::organizations");
        if (orgs.getConcepts().stream().map(c -> c.getId()).collect(Collectors.toList()).contains(communityId + "::organizations" + "::" + organization.getId())) {
            orgs.getConcepts().forEach(concept -> {
                if (concept.getId().equals(communityId + "::organizations" + "::" + organization.getId())) {
                    if (organization.getName() != null) {
                        if (concept.getParams().keySet().contains("name")) {
                            concept.getParams().replace("name", Arrays.asList(new Param().setName("name").setValue(organization.getName())));
                        } else {
                            concept.getParams().put("name", Arrays.asList(new Param().setName("name").setValue(organization.getName())));
                        }
                    }
                    if (organization.getLogo_url() != null) {
                        if (concept.getParams().keySet().contains("logourl")) {
                            concept.getParams().replace("logourl", Arrays.asList(new Param().setName("logourl").setValue(Base64.getEncoder().encodeToString(organization.getLogo_url().getBytes()))));
                        } else {
                            concept.getParams().put("logourl", Arrays.asList(new Param().setName("logourl").setValue(Base64.getEncoder().encodeToString(organization.getLogo_url().getBytes()))));
                        }
                    }
                    if (organization.getWebsite_url() != null) {
                        if (concept.getParams().keySet().contains("websiteurl")) {
                            concept.getParams().replace("websiteurl", Arrays.asList(new Param().setName("websiteurl").setValue(Base64.getEncoder().encodeToString(organization.getWebsite_url().getBytes()))));
                        } else {
                            concept.getParams().put("websiteurl", Arrays.asList(new Param().setName("websiteurl").setValue(Base64.getEncoder().encodeToString(organization.getWebsite_url().getBytes()))));
                        }
                    }
                }
            });
        } else {
            Concept concept2 = new Concept();
            concept2.setId(communityId + "::organizations" + "::" + organization.getId());
            concept2.setClaim(false);
            concept2.setLabel("");
            TreeMap<String, List<Param>> params = new TreeMap<String, List<Param>>();
            if (organization.getName() != null) {
                params.put("name", Arrays.asList(new Param().setValue(organization.getName()).setName("name")));
            }
            if (organization.getLogo_url() != null) {
                params.put("logourl", Arrays.asList(new Param().setValue(Base64.getEncoder().encodeToString(organization.getLogo_url().getBytes())).setName("logourl")));
            }
            if (organization.getWebsite_url() != null) {
                params.put("websiteurl", Arrays.asList(new Param().setValue(Base64.getEncoder().encodeToString(organization.getWebsite_url().getBytes())).setName("websiteurl")));
            }
            concept2.setParams(params);
            orgs.getConcepts().add(concept2);
        }
    }

    public void updateZenodoCommunity(String communityId, CommunityZenodoCommunity zc) throws CommunityException {
        Context context = (Context)this.getContextMap().get(communityId);
        Category zcs = (Category)context.getCategories().get(communityId + "::zenodocommunities");
        if (zcs.getConcepts().stream().map(c -> c.getId()).collect(Collectors.toList()).contains(communityId + "::zenodocommunities" + "::" + zc.getId())) {
            zcs.getConcepts().forEach(concept -> {
                if (concept.getId().equals(communityId + "::zenodocommunities" + "::" + zc.getId()) && zc.getZenodoid() != null) {
                    if (concept.getParams().keySet().contains("zenodoid")) {
                        concept.getParams().replace("zenodoid", Arrays.asList(new Param().setName("zenodoid").setValue(zc.getZenodoid())));
                    } else {
                        concept.getParams().put("zenodoid", Arrays.asList(new Param().setName("zenodoid").setValue(zc.getZenodoid())));
                    }
                }
            });
        } else {
            Concept concept2 = new Concept();
            concept2.setId(communityId + "::zenodocommunities" + "::" + zc.getId());
            concept2.setClaim(false);
            TreeMap<String, List<Param>> params = new TreeMap<String, List<Param>>();
            if (zc.getZenodoid() != null) {
                params.put("zenodoid", Arrays.asList(new Param().setValue(zc.getZenodoid()).setName("zenodoid")));
                concept2.setLabel(zc.getZenodoid());
            } else {
                concept2.setLabel("");
            }
            concept2.setParams(params);
            zcs.getConcepts().add(concept2);
        }
    }
}

