package eu.dnetlib;

import static springfox.documentation.builders.RequestHandlerSelectors.basePackage;

import java.time.LocalDate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

import eu.dnetlib.DnetOpenaireExporterProperties.Swagger;
import eu.dnetlib.common.app.AbstractDnetApp;
import eu.dnetlib.openaire.community.CommunityApiController;
import eu.dnetlib.openaire.context.ContextApiController;
import eu.dnetlib.openaire.dsm.DsmApiController;
import eu.dnetlib.openaire.funders.FundersApiController;
import eu.dnetlib.openaire.info.InfoController;
import eu.dnetlib.openaire.project.ProjectsController;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableCaching
@EnableScheduling
@EnableSwagger2
@SpringBootApplication
@EnableAutoConfiguration(exclude = {
	SolrAutoConfiguration.class
})
public class DNetOpenaireExporterApplication extends AbstractDnetApp {

	public static final String V1 = "1.0.0";

	public static void main(final String[] args) throws Exception {
		SpringApplication.run(DNetOpenaireExporterApplication.class, args);
	}

	@Autowired
	private DnetOpenaireExporterProperties config;

	@Bean
	public Docket dsm() {
		return _docket("Datasource Manager", DsmApiController.class.getPackage().getName(), config.getSwaggerDsm(), V1);
	}

	@Bean
	public Docket projects() {
		return _docket("OpenAIRE Projects", ProjectsController.class.getPackage().getName(), config.getSwaggerProjects(), V1);
	}

	@Bean
	public Docket funders() {
		return _docket("OpenAIRE Funders", FundersApiController.class.getPackage().getName(), config.getSwaggerFunders(), V1);
	}

	@Bean
	public Docket communities() {
		return _docket("OpenAIRE Communities", CommunityApiController.class.getPackage().getName(), config.getSwaggerCommunities(), V1);
	}

	@Bean
	public Docket contexts() {
		return _docket("OpenAIRE Contexts", ContextApiController.class.getPackage().getName(), config.getSwaggerCommunities(), V1);
	}

	private Docket _docket(final String groupName, final String controllerPackage, final Swagger swag, final String version) {
		final Docket d = new Docket(DocumentationType.SWAGGER_2);
		configSwagger(d, groupName, controllerPackage, swag, version);
		return d;
	}

	@Override
	protected void configSwagger(final Docket docket) {
		configSwagger(docket, "OpenAIRE Info", InfoController.class.getPackage().getName(), config.getSwaggerInfo(), V1);
	}

	private void configSwagger(final Docket docket, final String groupName, final String controllerPackage, final Swagger swag, final String version) {
		docket
			.groupName(groupName)
			.select()
			.apis(basePackage(controllerPackage))
			.build()
			.directModelSubstitute(LocalDate.class, java.sql.Date.class)
			.apiInfo(apiInfo(swag, version));
	}

	private ApiInfo apiInfo(final Swagger swag, final String version) {
		return new ApiInfoBuilder()
			.title(swag.getApiTitle())
			.description(swag.getApiDescription())
			.license(swag.getApiLicense())
			.licenseUrl(swag.getApiLicenseUrl())
			.termsOfServiceUrl("")
			.version(version)
			.contact(new Contact(
				swag.getApiContactName(),
				swag.getApiContactUrl(),
				swag.getApiContactEmail()))
			.build();
	}

}
