/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.utils.mail;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailMessage {
    private static final Log log = LogFactory.getLog(EmailMessage.class);
    private final MimeMessage mimeMessage;

    protected EmailMessage(Session session, String subject, String content, String fromMail, String fromName, String to, String ... ccs) throws MessagingException, UnsupportedEncodingException, AddressException {
        this.mimeMessage = new MimeMessage(session);
        this.mimeMessage.setFrom((Address)new InternetAddress(fromMail, fromName));
        this.mimeMessage.setSubject(subject);
        this.mimeMessage.setContent((Object)content, "text/html; charset=utf-8");
        this.mimeMessage.setSentDate(new Date());
        this.mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        for (String cc : ccs) {
            this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
        }
    }

    public void sendMailAsync() {
        Thread t = new Thread(() -> this.sendMail());
        t.start();
    }

    public void sendMail() {
        try {
            log.info((Object)("Sending mail to " + Arrays.toString(this.mimeMessage.getAllRecipients()) + "..."));
            Transport.send((Message)this.mimeMessage);
            log.info((Object)"...sent");
        }
        catch (MessagingException e) {
            log.error((Object)"Error sending mail", (Throwable)e);
        }
    }
}

