/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.app;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.util.StringUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractDnetApp {
    private static final String DEFAULT_VERSION = "1.1";
    private static final String DEFAULT_DESC = "APIs documentation";
    protected static final License APACHE_2_LICENSE = new License().name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0");
    protected static final License AGPL_3_LICENSE = new License().name("GNU Affero General Public License v3.0 or later").url("https://www.gnu.org/licenses/agpl-3.0.txt");
    @Value(value="${maven.pom.path}")
    private ClassPathResource pom;
    @Value(value="${server.public_url}")
    private String serverPublicUrl;
    @Value(value="${server.public_desc}")
    private String serverPublicDesc;
    private static final Logger log = LoggerFactory.getLogger(AbstractDnetApp.class);

    @PostConstruct
    public void init() {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read((Reader)new InputStreamReader(this.pom.getInputStream()));
            log.info(String.format("registering metric for %s", model.getArtifactId()));
            ImmutableTag tag1 = new ImmutableTag("component", model.getGroupId() + ":" + model.getArtifactId());
            ImmutableTag tag2 = new ImmutableTag("version", model.getVersion());
            ImmutableTag tag3 = new ImmutableTag("scmtag", model.getScm().getTag());
            Metrics.gauge((String)"micrometer_info", Arrays.asList(tag1, tag2, tag3), (Number)1);
        }
        catch (IOException | XmlPullParserException e) {
            log.error("Error registering metric", e);
        }
    }

    @Bean
    public OpenAPI newSwaggerDocket() {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (StringUtils.isNotBlank((String)this.serverPublicUrl)) {
            Server server = new Server();
            server.setUrl(this.serverPublicUrl);
            server.setDescription(this.serverPublicDesc);
            servers.add(server);
        }
        return new OpenAPI().servers(servers).info(this.getSwaggerInfo()).tags(this.swaggerTags());
    }

    private Info getSwaggerInfo() {
        return new Info().title(this.swaggerTitle()).description(this.swaggerDesc()).version(this.swaggerVersion()).license(this.swaggerLicense());
    }

    protected abstract String swaggerTitle();

    protected String swaggerDesc() {
        return DEFAULT_DESC;
    }

    protected String swaggerVersion() {
        return DEFAULT_VERSION;
    }

    protected License swaggerLicense() {
        return AGPL_3_LICENSE;
    }

    protected List<Tag> swaggerTags() {
        return new ArrayList<Tag>();
    }
}

