/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oa.graph.usagerawdata.export;

import eu.dnetlib.oa.graph.usagerawdata.export.ConnectDB;
import eu.dnetlib.oa.graph.usagerawdata.export.ExecuteWorkflow;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrusStats {
    private String irusUKURL;
    private static final Logger logger = LoggerFactory.getLogger(IrusStats.class);

    public IrusStats(String irusUKURL) throws Exception {
        this.irusUKURL = irusUKURL;
    }

    public void reCreateLogDirs() throws Exception {
        FileSystem dfs = FileSystem.get((Configuration)new Configuration());
        logger.info("Deleting irusUKReport directory: " + ExecuteWorkflow.irusUKReportPath);
        dfs.delete(new Path(ExecuteWorkflow.irusUKReportPath), true);
        logger.info("Creating irusUKReport directory: " + ExecuteWorkflow.irusUKReportPath);
        dfs.mkdirs(new Path(ExecuteWorkflow.irusUKReportPath));
    }

    public void createTables() throws Exception {
        try {
            logger.info("Creating sushilog");
            Statement stmt = ConnectDB.getHiveConnection().createStatement();
            String sqlCreateTableSushiLog = "CREATE TABLE IF NOT EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".sushilog(source STRING, repository STRING, rid STRING, date STRING, metric_type STRING, count INT)  clustered by (source, repository, rid, date, metric_type) into 100 buckets stored as orc tblproperties('transactional'='true')";
            stmt.executeUpdate(sqlCreateTableSushiLog);
            logger.info("Created sushilog");
            stmt.close();
            ConnectDB.getHiveConnection().close();
            logger.info("Sushi Tables Created");
        }
        catch (Exception e) {
            logger.error("Failed to create tables: " + e);
            throw new Exception("Failed to create tables: " + e.toString(), e);
        }
    }

    public void processIrusStats() throws Exception {
        Statement stmt = ConnectDB.getHiveConnection().createStatement();
        ConnectDB.getHiveConnection().setAutoCommit(false);
        logger.info("Adding JSON Serde jar");
        stmt.executeUpdate("add jar /usr/share/cmf/common_jars/hive-hcatalog-core-1.1.0-cdh5.14.0.jar");
        logger.info("Added JSON Serde jar");
        logger.info("Dropping sushilogtmp_json table");
        String dropSushilogtmpJson = "DROP TABLE IF EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".sushilogtmp_json";
        stmt.executeUpdate(dropSushilogtmpJson);
        logger.info("Dropped sushilogtmp_json table");
        logger.info("Creating irus_sushilogtmp_json table");
        String createSushilogtmpJson = "CREATE EXTERNAL TABLE IF NOT EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp_json(\n\t`ItemIdentifier` ARRAY<\n\t\t\t\t\t\tstruct<\n\t\t\t\t\t\t\tType: STRING,\n\t\t\t\t\t\t\tValue: STRING\n\t\t\t\t\t\t\t>\n\t\t\t\t\t\t>,\n\t`ItemPerformance` ARRAY<\n\t\t\t\t\t\tstruct<\n\t\t\t\t\t\t\t`Period`:  struct<\n\t\t\t\t\t\t\t\t\t\t`Begin`: STRING,\n\t\t\t\t\t\t\t\t\t\t`End`: STRING\n\t\t\t\t\t\t\t\t\t\t>,\n\t\t\t\t\t\t\t`Instance`:  struct<\n\t\t\t\t\t\t\t\t\t\t`Count`: STRING,\n\t\t\t\t\t\t\t\t\t\t`MetricType`: STRING\n\t\t\t\t\t\t\t\t\t\t>\n\t\t\t\t\t\t\t>\n\t\t\t\t\t\t>\n)\nROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe'\nLOCATION '" + ExecuteWorkflow.irusUKReportPath + "'\nTBLPROPERTIES (\"transactional\"=\"false\")";
        stmt.executeUpdate(createSushilogtmpJson);
        logger.info("Created irus_sushilogtmp_json table");
        logger.info("Dropping irus_sushilogtmp table");
        String dropSushilogtmp = "DROP TABLE IF EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp";
        stmt.executeUpdate(dropSushilogtmp);
        logger.info("Dropped irus_sushilogtmp table");
        logger.info("Creating irus_sushilogtmp table");
        String createSushilogtmp = "CREATE TABLE " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp(source STRING, repository STRING, rid STRING, date STRING, metric_type STRING, count INT) clustered by (source) into 100 buckets stored as orc tblproperties('transactional'='true')";
        stmt.executeUpdate(createSushilogtmp);
        logger.info("Created irus_sushilogtmp table");
        logger.info("Inserting to irus_sushilogtmp table");
        String insertSushilogtmp = "INSERT INTO  " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp SELECT 'IRUS-UK', CONCAT('opendoar____::', split(split(INPUT__FILE__NAME,'IrusIRReport_')[1],'_')[0]), `ItemIdent`.`Value`, `ItemPerf`.`Period`.`Begin`, `ItemPerf`.`Instance`.`MetricType`, `ItemPerf`.`Instance`.`Count` FROM " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp_json LATERAL VIEW posexplode(ItemIdentifier) ItemIdentifierTable AS seqi, ItemIdent LATERAL VIEW posexplode(ItemPerformance) ItemPerformanceTable AS seqp, ItemPerf WHERE `ItemIdent`.`Type`= 'OAI'";
        stmt.executeUpdate(insertSushilogtmp);
        logger.info("Inserted to irus_sushilogtmp table");
        logger.info("Inserting to sushilog table");
        String insertToShushilog = "INSERT INTO " + ConnectDB.getUsageStatsDBSchema() + ".sushilog SELECT * FROM " + ConnectDB.getUsageStatsDBSchema() + ".irus_sushilogtmp";
        stmt.executeUpdate(insertToShushilog);
        logger.info("Inserted to sushilog table");
        ConnectDB.getHiveConnection().close();
    }

    public void getIrusRRReport(String irusUKReportPath) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM");
        Calendar start = (Calendar)ExecuteWorkflow.startingLogPeriod.clone();
        logger.info("(getIrusRRReport) Starting period for log download: " + sdf.format(start.getTime()));
        Calendar end = Calendar.getInstance();
        end.add(5, -1);
        logger.info("(getIrusRRReport) Ending period for log download: " + sdf.format(end.getTime()));
        String reportUrl = this.irusUKURL + "GetReport/?Report=RR1&Release=4&RequestorID=OpenAIRE&BeginDate=" + sdf.format(start.getTime()) + "&EndDate=" + sdf.format(end.getTime()) + "&RepositoryIdentifier=&ItemDataType=&NewJiscBand=&Granularity=Monthly&Callback=";
        logger.info("(getIrusRRReport) Getting report: " + reportUrl);
        String text = this.getJson(reportUrl, "", "");
        List<String> opendoarsToVisit = new ArrayList();
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(text);
        jsonObject = (JSONObject)jsonObject.get((Object)"ReportResponse");
        jsonObject = (JSONObject)jsonObject.get((Object)"Report");
        jsonObject = (JSONObject)jsonObject.get((Object)"Report");
        jsonObject = (JSONObject)jsonObject.get((Object)"Customer");
        JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"ReportItems");
        if (jsonArray != null) {
            int i = 0;
            block0: for (Object aJsonArray : jsonArray) {
                JSONObject jsonObjectRow = (JSONObject)aJsonArray;
                JSONArray itemIdentifier = (JSONArray)jsonObjectRow.get((Object)"ItemIdentifier");
                for (Object identifier : itemIdentifier) {
                    JSONObject opendoar = (JSONObject)identifier;
                    if (!opendoar.get((Object)"Type").toString().equals("OpenDOAR")) continue;
                    ++i;
                    opendoarsToVisit.add(opendoar.get((Object)"Value").toString());
                    continue block0;
                }
            }
            logger.info("(getIrusRRReport) Found the following opendoars for download: " + opendoarsToVisit);
            if (ExecuteWorkflow.irusNumberOfOpendoarsToDownload > 0 && ExecuteWorkflow.irusNumberOfOpendoarsToDownload <= opendoarsToVisit.size()) {
                logger.info("Trimming siteIds list to the size of: " + ExecuteWorkflow.irusNumberOfOpendoarsToDownload);
                opendoarsToVisit = opendoarsToVisit.subList(0, ExecuteWorkflow.irusNumberOfOpendoarsToDownload);
            }
            logger.info("(getIrusRRReport) Downloading the followins opendoars: " + opendoarsToVisit);
            for (String opendoar : opendoarsToVisit) {
                logger.info("Now working on openDoar: " + opendoar);
                this.getIrusIRReport(opendoar, irusUKReportPath);
            }
            logger.info("(getIrusRRReport) Finished with report: " + reportUrl);
        } else {
            logger.info("IRUS Reports not found for day");
        }
    }

    private void getIrusIRReport(String opendoar, String irusUKReportPath) throws Exception {
        logger.info("(getIrusIRReport) Getting report(s) with opendoar: " + opendoar);
        ConnectDB.getHiveConnection().setAutoCommit(false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYY-MM");
        Calendar start = (Calendar)ExecuteWorkflow.startingLogPeriod.clone();
        logger.info("(getIrusIRReport) Starting period for log download: " + simpleDateFormat.format(start.getTime()));
        Calendar end = Calendar.getInstance();
        end.add(5, -1);
        logger.info("(getIrusIRReport) Ending period for log download: " + simpleDateFormat.format(end.getTime()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        PreparedStatement st = ConnectDB.getHiveConnection().prepareStatement("SELECT max(date) FROM " + ConnectDB.getUsageStatsDBSchema() + ".sushilog WHERE repository=?");
        st.setString(1, "opendoar____::" + opendoar);
        ResultSet rs_date = st.executeQuery();
        Date dateMax = null;
        while (rs_date.next()) {
            if (rs_date.getString(1) == null || rs_date.getString(1).equals("null") || rs_date.getString(1).equals("")) continue;
            start.setTime(sdf.parse(rs_date.getString(1)));
            dateMax = sdf.parse(rs_date.getString(1));
        }
        rs_date.close();
        boolean batch_size = false;
        if (dateMax != null && end.getTime().compareTo(dateMax) <= 0) {
            logger.info("Date found in logs " + dateMax + " and not downloanding logs for " + opendoar);
        } else {
            start.add(2, 1);
            while (start.before(end)) {
                logger.info("Downloading for date: " + simpleDateFormat.format(start.getTime()));
                String reportUrl = this.irusUKURL + "GetReport/?Report=IR1&Release=4&RequestorID=OpenAIRE&BeginDate=" + simpleDateFormat.format(start.getTime()) + "&EndDate=" + simpleDateFormat.format(start.getTime()) + "&RepositoryIdentifier=opendoar%3A" + opendoar + "&ItemIdentifier=&ItemDataType=&hasDOI=&Granularity=Monthly&Callback=";
                start.add(2, 1);
                logger.info("Downloading file: " + reportUrl);
                String text = this.getJson(reportUrl, "", "");
                if (text == null) continue;
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                String filePath = irusUKReportPath + "/IrusIRReport_" + opendoar + "_" + simpleDateFormat.format(start.getTime()) + ".json";
                logger.info("Storing to file: " + filePath);
                FSDataOutputStream fin = fs.create(new Path(filePath), true);
                JSONParser parser = new JSONParser();
                JSONObject jsonObject = (JSONObject)parser.parse(text);
                jsonObject = (JSONObject)jsonObject.get((Object)"ReportResponse");
                jsonObject = (JSONObject)jsonObject.get((Object)"Report");
                jsonObject = (JSONObject)jsonObject.get((Object)"Report");
                jsonObject = (JSONObject)jsonObject.get((Object)"Customer");
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"ReportItems");
                if (jsonArray == null) continue;
                String oai = "";
                for (Object aJsonArray : jsonArray) {
                    JSONObject jsonObjectRow = (JSONObject)aJsonArray;
                    fin.write(jsonObjectRow.toJSONString().getBytes());
                    fin.writeChar(10);
                }
                fin.close();
            }
        }
        logger.info("(getIrusIRReport) Finished downloading report(s) with opendoar: " + opendoar);
    }

    private String getJson(String url) throws Exception {
        try {
            StringBuilder response;
            System.out.println("===> Connecting to: " + url);
            URL website = new URL(url);
            System.out.println("Connection url -----> " + url);
            URLConnection connection = website.openConnection();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            System.out.println("response ====> " + response.toString());
            return response.toString();
        }
        catch (Exception e) {
            logger.error("Failed to get URL: " + e);
            System.out.println("Failed to get URL: " + e);
            throw new Exception("Failed to get URL: " + e.toString(), e);
        }
    }

    private String getJson(String url, String username, String password) throws Exception {
        try {
            StringBuilder response;
            URL website = new URL(url);
            URLConnection connection = website.openConnection();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                    response.append("\n");
                }
            }
            return response.toString();
        }
        catch (Exception e) {
            logger.error("Failed to get URL", (Throwable)e);
            return null;
        }
    }
}

