/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v2.RelationshipType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotBlank;

public class ScholixRelationship {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="schema")
    private String schema = null;
    @NotBlank
    @JsonProperty(value="inverseRelationship")
    private String inverseRelationship = null;

    public ScholixRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The relationship type chosen from a Scholix controlled vocabulary")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScholixRelationship schema(String schema) {
        this.schema = schema;
        return this;
    }

    @Schema(description="The name of the schema or controlled list from which Relationship Sub-type is sourced")
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ScholixRelationship inverseRelationship(String inverseRelationship) {
        this.inverseRelationship = inverseRelationship;
        return this;
    }

    @Schema(description="The value of the inverse relation")
    public String getInverseRelationship() {
        return this.inverseRelationship;
    }

    public void setInverseRelationship(String inverseRelationship) {
        this.inverseRelationship = inverseRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScholixRelationship relationshipType = (ScholixRelationship)o;
        return Objects.equals(this.name, relationshipType.name) && Objects.equals(this.schema, relationshipType.schema) && Objects.equals(this.inverseRelationship, relationshipType.inverseRelationship);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schema, this.inverseRelationship);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationshipType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    subTypeSchema: ").append(this.toIndentedString(this.inverseRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ScholixRelationship fromScholixIndexRelationship(eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship inputRel) {
        if (inputRel == null) {
            return null;
        }
        ScholixRelationship result = new ScholixRelationship();
        result.setName(RelationshipType.relationMapping.getOrDefault(inputRel.getName(), "IsRelatedTo"));
        result.setInverseRelationship(RelationshipType.relationMapping.getOrDefault(inputRel.getInverse(), "IsRelatedTo"));
        result.setSchema(inputRel.getSchema());
        return result;
    }
}

