/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.countrypropagation;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.countrypropagation.SparkCountryPropagationJob;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CountryPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(CountryPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(CountryPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(CountryPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(CountryPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testCountryPropagationSoftware() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/graph/software").getPath();
        String preparedInfoPath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/preparedInfo/software").getPath();
        SparkCountryPropagationJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "-resultTableName", Software.class.getCanonicalName(), "-outputPath", workingDir.toString() + "/software", "-preparedInfoPath", preparedInfoPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/software").map((Function & Serializable)item -> (Software)OBJECT_MAPPER.readValue(item, Software.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Software.class));
        Assertions.assertEquals((long)6L, (long)verificationDs.filter("size(country) > 0").count());
        Assertions.assertEquals((long)3L, (long)verificationDs.filter("size(country) = 1").count());
        Assertions.assertEquals((long)3L, (long)verificationDs.filter("size(country) = 2").count());
        Assertions.assertEquals((long)0L, (long)verificationDs.filter("size(country) > 2").count());
        Dataset countryExploded = verificationDs.flatMap((FlatMapFunction & Serializable)row -> row.getCountry().iterator(), Encoders.bean(Country.class)).map(Qualifier::getClassid, Encoders.STRING());
        Assertions.assertEquals((long)9L, (long)countryExploded.count());
        Assertions.assertEquals((long)1L, (long)countryExploded.filter("value = 'FR'").count());
        Assertions.assertEquals((long)1L, (long)countryExploded.filter("value = 'TR'").count());
        Assertions.assertEquals((long)2L, (long)countryExploded.filter("value = 'IT'").count());
        Assertions.assertEquals((long)1L, (long)countryExploded.filter("value = 'US'").count());
        Assertions.assertEquals((long)1L, (long)countryExploded.filter("value = 'MX'").count());
        Assertions.assertEquals((long)1L, (long)countryExploded.filter("value = 'CH'").count());
        Assertions.assertEquals((long)2L, (long)countryExploded.filter("value = 'JP'").count());
        Dataset countryExplodedWithCountryclassid = verificationDs.flatMap((FlatMapFunction & Serializable)row -> {
            ArrayList prova = new ArrayList();
            List countryList = row.getCountry();
            countryList.forEach(c -> prova.add(new Tuple2((Object)row.getId(), (Object)c.getClassid())));
            return prova.iterator();
        }, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
        Assertions.assertEquals((long)9L, (long)countryExplodedWithCountryclassid.count());
        countryExplodedWithCountryclassid.show(false);
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|od______1582::6e7a9b21a2feef45673890432af34244' and _2 = 'FR' ").count());
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|dedup_wf_001::40ea2f24181f6ae77b866ebcbffba523' and _2 = 'TR' ").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|od______1106::2b7ca9726230be8e862be224fd463ac4' and (_2 = 'IT' or _2 = 'MX') ").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|od_______935::46a0ad9964171c3dd13373f5427b9a1c' and (_2 = 'IT' or _2 = 'US') ").count());
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|dedup_wf_001::b67bc915603fc01e445f2b5888ba7218' and _2 = 'JP'").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassid.filter("_1 = '50|od_______109::f375befa62a741e9250e55bcfa88f9a6' and (_2 = 'CH' or _2 = 'JP') ").count());
        Dataset countryExplodedWithCountryclassname = verificationDs.flatMap((FlatMapFunction & Serializable)row -> {
            ArrayList prova = new ArrayList();
            List countryList = row.getCountry();
            countryList.forEach(c -> prova.add(new Tuple2((Object)row.getId(), (Object)c.getClassname())));
            return prova.iterator();
        }, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
        countryExplodedWithCountryclassname.show(false);
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|od______1582::6e7a9b21a2feef45673890432af34244' and _2 = 'France' ").count());
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|dedup_wf_001::40ea2f24181f6ae77b866ebcbffba523' and _2 = 'Turkey' ").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|od______1106::2b7ca9726230be8e862be224fd463ac4' and (_2 = 'Italy' or _2 = 'Mexico') ").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|od_______935::46a0ad9964171c3dd13373f5427b9a1c' and (_2 = 'Italy' or _2 = 'United States') ").count());
        Assertions.assertEquals((long)1L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|dedup_wf_001::b67bc915603fc01e445f2b5888ba7218' and _2 = 'Japan' ").count());
        Assertions.assertEquals((long)2L, (long)countryExplodedWithCountryclassname.filter("_1 = '50|od_______109::f375befa62a741e9250e55bcfa88f9a6' and (_2 = 'Switzerland' or _2 = 'Japan') ").count());
        Dataset countryExplodedWithCountryProvenance = verificationDs.flatMap((FlatMapFunction & Serializable)row -> {
            ArrayList prova = new ArrayList();
            List countryList = row.getCountry();
            countryList.forEach(c -> prova.add(new Tuple2((Object)row.getId(), (Object)c.getDataInfo().getInferenceprovenance())));
            return prova.iterator();
        }, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
        Assertions.assertEquals((long)7L, (long)countryExplodedWithCountryProvenance.filter("_2 = 'propagation'").count());
    }

    @Test
    void testCountryPropagationPublication() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/graph/publication").getPath();
        String preparedInfoPath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/preparedInfo/publication").getPath();
        SparkCountryPropagationJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "-resultTableName", Publication.class.getCanonicalName(), "-outputPath", workingDir.toString() + "/publication", "-preparedInfoPath", preparedInfoPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/publication").map((Function & Serializable)item -> (Publication)OBJECT_MAPPER.readValue(item, Publication.class));
        Assertions.assertEquals((long)12L, (long)tmp.count());
        Assertions.assertEquals((long)5L, (long)tmp.filter((Function & Serializable)r -> r.getCountry().size() > 0).count());
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"dnet:countries", (Object)c.getSchemeid())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"dnet:countries", (Object)c.getSchemename())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertFalse((boolean)c.getDataInfo().getDeletedbyinference())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertFalse((boolean)c.getDataInfo().getInvisible())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertTrue((boolean)c.getDataInfo().getInferred())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"0.85", (Object)c.getDataInfo().getTrust())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"propagation", (Object)c.getDataInfo().getInferenceprovenance())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"country:instrepos", (Object)c.getDataInfo().getProvenanceaction().getClassid())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)c.getDataInfo().getProvenanceaction().getSchemeid())));
        tmp.foreach((VoidFunction & Serializable)r -> r.getCountry().stream().forEach(c -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)c.getDataInfo().getProvenanceaction().getSchemename())));
        List countries = ((Publication)tmp.filter((Function & Serializable)r -> r.getId().equals("50|06cdd3ff4700::49ec404cee4e1452808aabeaffbd3072")).collect().get(0)).getCountry();
        Assertions.assertEquals((int)1, (int)countries.size());
        Assertions.assertEquals((Object)"NL", (Object)((Country)countries.get(0)).getClassid());
        Assertions.assertEquals((Object)"Netherlands", (Object)((Country)countries.get(0)).getClassname());
        countries = ((Publication)tmp.filter((Function & Serializable)r -> r.getId().equals("50|07b5c0ccd4fe::e7f5459cc97865f2af6e3da964c1250b")).collect().get(0)).getCountry();
        Assertions.assertEquals((int)1, (int)countries.size());
        Assertions.assertEquals((Object)"NL", (Object)((Country)countries.get(0)).getClassid());
        Assertions.assertEquals((Object)"Netherlands", (Object)((Country)countries.get(0)).getClassname());
        countries = ((Publication)tmp.filter((Function & Serializable)r -> r.getId().equals("50|355e65625b88::e7d48a470b13bda61f7ebe3513e20cb6")).collect().get(0)).getCountry();
        Assertions.assertEquals((int)2, (int)countries.size());
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("FR") && cs.getClassname().equals("France")));
        countries = ((Publication)tmp.filter((Function & Serializable)r -> r.getId().equals("50|355e65625b88::74009c567c81b4aa55c813db658734df")).collect().get(0)).getCountry();
        Assertions.assertEquals((int)2, (int)countries.size());
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("NL") && cs.getClassname().equals("Netherlands")));
        countries = ((Publication)tmp.filter((Function & Serializable)r -> r.getId().equals("50|355e65625b88::54a1c76f520bb2c8da27d12e42891088")).collect().get(0)).getCountry();
        Assertions.assertEquals((int)2, (int)countries.size());
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)countries.stream().anyMatch(cs -> cs.getClassid().equals("FR") && cs.getClassname().equals("France")));
    }
}

