/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup.sx;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dedup.sx.SparkUpdateEntityJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;

public class SparkPropagateRelationsJob {
    static final String SOURCEJSONPATH = "$.source";
    static final String TARGETJSONPATH = "$.target";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkPropagateRelationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/sx/dedup/dedup_propagate_relation_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkUpdateEntityJob.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String relationPath = parser.get("relationPath");
        String mergeRelPath = parser.get("mergeRelPath");
        String targetRelPath = parser.get("targetRelPath");
        Dataset merge = spark.read().load(mergeRelPath).as(Encoders.bean(Relation.class)).where("relClass == 'merges'");
        Dataset rels = spark.read().load(relationPath).as(Encoders.bean(Relation.class));
        Dataset firstJoin = rels.joinWith(merge, merge.col("target").equalTo((Object)rels.col("source")), "left_outer").map((MapFunction & Serializable)r -> {
            Relation mergeRelation = (Relation)r._2();
            Relation relation = (Relation)r._1();
            if (mergeRelation != null) {
                relation.setSource(mergeRelation.getSource());
            }
            return relation;
        }, Encoders.bean(Relation.class));
        Dataset secondJoin = firstJoin.joinWith(merge, merge.col("target").equalTo((Object)firstJoin.col("target")), "left_outer").map((MapFunction & Serializable)r -> {
            Relation mergeRelation = (Relation)r._2();
            Relation relation = (Relation)r._1();
            if (mergeRelation != null) {
                relation.setTarget(mergeRelation.getSource());
            }
            return relation;
        }, Encoders.bean(Relation.class));
        secondJoin.write().mode(SaveMode.Overwrite).save(targetRelPath);
    }

    private static boolean containsDedup(String json) {
        String source = DHPUtils.getJPathString((String)SOURCEJSONPATH, (String)json);
        String target = DHPUtils.getJPathString((String)TARGETJSONPATH, (String)json);
        return source.toLowerCase().contains("dedup") || target.toLowerCase().contains("dedup");
    }

    private static String replaceField(String json, String id, FieldType type) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Relation relation = (Relation)mapper.readValue(json, Relation.class);
            if (relation.getDataInfo() == null) {
                relation.setDataInfo(new DataInfo());
            }
            relation.getDataInfo().setDeletedbyinference(Boolean.valueOf(false));
            switch (type) {
                case SOURCE: {
                    relation.setSource(id);
                    return mapper.writeValueAsString((Object)relation);
                }
                case TARGET: {
                    relation.setTarget(id);
                    return mapper.writeValueAsString((Object)relation);
                }
            }
            throw new IllegalArgumentException("");
        }
        catch (IOException e) {
            throw new RuntimeException("unable to deserialize json relation: " + json, e);
        }
    }

    static enum FieldType {
        SOURCE,
        TARGET;

    }
}

