/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Notification;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(IndexNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_notifications.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String notificationsPath = parser.get("outputDir") + "/notifications";
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String esBatchWriteRetryCount = parser.get("esBatchWriteRetryCount");
        log.info("esBatchWriteRetryCount: {}", (Object)esBatchWriteRetryCount);
        String esBatchWriteRetryWait = parser.get("esBatchWriteRetryWait");
        log.info("esBatchWriteRetryWait: {}", (Object)esBatchWriteRetryWait);
        String esBatchSizeEntries = parser.get("esBatchSizeEntries");
        log.info("esBatchSizeEntries: {}", (Object)esBatchSizeEntries);
        String esNodesWanOnly = parser.get("esNodesWanOnly");
        log.info("esNodesWanOnly: {}", (Object)esNodesWanOnly);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_indexed");
        Long date = ((Notification)ClusterUtils.readPath(spark, notificationsPath, Notification.class).first()).getDate();
        JavaRDD toIndexRdd = ClusterUtils.readPath(spark, notificationsPath, Notification.class).map((MapFunction & Serializable)n -> IndexNotificationsJob.prepareForIndexing(n, total), Encoders.STRING()).javaRDD();
        HashMap<String, String> esCfg = new HashMap<String, String>();
        esCfg.put("es.index.auto.create", "false");
        esCfg.put("es.nodes", indexHost);
        esCfg.put("es.mapping.id", "notificationId");
        esCfg.put("es.batch.write.retry.count", esBatchWriteRetryCount);
        esCfg.put("es.batch.write.retry.wait", esBatchWriteRetryWait);
        esCfg.put("es.batch.size.entries", esBatchSizeEntries);
        esCfg.put("es.nodes.wan.only", esNodesWanOnly);
        log.info("*** Start indexing");
        JavaEsSpark.saveJsonToEs((JavaRDD)toIndexRdd, (String)index, esCfg);
        log.info("*** End indexing");
        log.info("*** Deleting old notifications");
        String message = IndexNotificationsJob.deleteOldNotifications(brokerApiBaseUrl, date - 1000L);
        log.info("*** Deleted notifications: {}", (Object)message);
        log.info("*** sendNotifications (emails, ...)");
        IndexNotificationsJob.sendNotifications(brokerApiBaseUrl, date - 1000L);
        log.info("*** ALL done.");
    }

    private static String deleteOldNotifications(String brokerApiBaseUrl, long l) throws Exception {
        String url = brokerApiBaseUrl + "/api/notifications/byDate/0/" + l;
        HttpDelete req = new HttpDelete(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    string = IOUtils.toString((InputStream)response.getEntity().getContent());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private static String sendNotifications(String brokerApiBaseUrl, long l) throws IOException {
        String url = brokerApiBaseUrl + "/api/openaireBroker/notifications/send/" + l;
        HttpGet req = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    string = IOUtils.toString((InputStream)response.getEntity().getContent());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private static String prepareForIndexing(Notification n, LongAccumulator acc) throws JsonProcessingException {
        acc.add(1L);
        return new ObjectMapper().writeValueAsString((Object)n);
    }
}

