/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.model;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class EventFactory {
    private static final String PRODUCER_ID = "OpenAIRE";
    private static final int TTH_DAYS = 365;
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd"};

    public static Event newBrokerEvent(Result source, Result target, UpdateInfo<?> updateInfo) {
        long now = new Date().getTime();
        Event res = new Event();
        Map<String, Object> map = EventFactory.createMapFromResult(target, source, updateInfo);
        String payload = EventFactory.createPayload(target, updateInfo);
        String eventId = EventFactory.calculateEventId(updateInfo.getTopic(), (String)target.getOriginalId().get(0), updateInfo.getHighlightValueAsString());
        res.setEventId(eventId);
        res.setProducerId(PRODUCER_ID);
        res.setPayload(payload);
        res.setMap(map);
        res.setTopic(updateInfo.getTopic());
        res.setCreationDate(now);
        res.setExpiryDate(EventFactory.calculateExpiryDate(now));
        res.setInstantMessage(false);
        return res;
    }

    private static String createPayload(Result result, UpdateInfo<?> updateInfo) {
        OpenAireEventPayload payload = new OpenAireEventPayload();
        updateInfo.compileHighlight(payload);
        return payload.toJSON();
    }

    private static Map<String, Object> createMapFromResult(Result oaf, Result source, UpdateInfo<?> updateInfo) {
        List authors;
        List subjects;
        long date;
        List titles;
        List ids;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List collectedFrom = oaf.getCollectedfrom();
        if (collectedFrom.size() == 1) {
            map.put("target_datasource_id", ((KeyValue)collectedFrom.get(0)).getKey());
            map.put("target_datasource_name", ((KeyValue)collectedFrom.get(0)).getValue());
        }
        if ((ids = oaf.getOriginalId()).size() > 0) {
            map.put("target_publication_id", ids.get(0));
        }
        if ((titles = oaf.getTitle()).size() > 0) {
            map.put("target_publication_title", titles.get(0));
        }
        if ((date = EventFactory.parseDateTolong((String)oaf.getDateofacceptance().getValue())) > 0L) {
            map.put("target_dateofacceptance", date);
        }
        if ((subjects = oaf.getSubject()).size() > 0) {
            map.put("target_publication_subject_list", subjects.stream().map(StructuredProperty::getValue).collect(Collectors.toList()));
        }
        if ((authors = oaf.getAuthor()).size() > 0) {
            map.put("target_publication_author_list", authors.stream().map(Author::getFullname).collect(Collectors.toList()));
        }
        map.put("trust", Float.valueOf(updateInfo.getTrust()));
        List sourceCollectedFrom = source.getCollectedfrom();
        if (sourceCollectedFrom.size() == 1) {
            map.put("provenance_datasource_id", ((KeyValue)sourceCollectedFrom.get(0)).getKey());
            map.put("provenance_datasource_name", ((KeyValue)sourceCollectedFrom.get(0)).getValue());
        }
        map.put("provenance_publication_id_list", source.getOriginalId());
        return map;
    }

    private static String calculateEventId(String topic, String publicationId, String value) {
        return "event-" + DigestUtils.md5Hex((String)topic).substring(0, 6) + "-" + DigestUtils.md5Hex((String)publicationId).substring(0, 8) + "-" + DigestUtils.md5Hex((String)value).substring(0, 8);
    }

    private static long calculateExpiryDate(long now) {
        return now + 1471228928L;
    }

    private static long parseDateTolong(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return -1L;
        }
        try {
            return DateUtils.parseDate((String)date, (String[])DATE_PATTERNS).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }
}

