/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.events.output;

import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.events.output.NotificationDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DispatcherManager {
    @Autowired(required=false)
    private final List<NotificationDispatcher> dispatchers = new ArrayList();
    private static final Log log = LogFactory.getLog(DispatcherManager.class);

    public void dispatch(Subscription s, Event ... events) {
        Optional<NotificationDispatcher> dispatcher = this.dispatchers.stream().filter(d -> d.getMode() == s.getMode()).findFirst();
        if (dispatcher.isPresent()) {
            dispatcher.get().sendNotification(s, events);
        } else {
            log.error((Object)("Notification dispatcher not found, mode=" + s.getMode()));
        }
    }

    public void sendNotification(Subscription s, Map<String, Object> params) {
        Optional<NotificationDispatcher> dispatcher = this.dispatchers.stream().filter(d -> d.getMode() == s.getMode()).findFirst();
        if (dispatcher.isPresent()) {
            dispatcher.get().sendNotification(s, params);
        } else {
            log.error((Object)("Notification dispatcher not found, mode=" + s.getMode()));
        }
    }

    public List<NotificationDispatcher> getDispatchers() {
        return this.dispatchers;
    }
}

