/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.dhp.actionmanager.migration.MigrateActionSet;
import eu.dnetlib.dhp.actionmanager.migration.ProtoConverter;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class TransformActions
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransformActions.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "/";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateActionSet.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/migration/transform_actionsets_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String inputPaths = parser.get("inputPaths");
        if (StringUtils.isBlank((CharSequence)inputPaths)) {
            throw new RuntimeException("empty inputPaths");
        }
        log.info("inputPaths: {}", (Object)inputPaths);
        String targetBaseDir = TransformActions.getTargetBaseDir(isLookupUrl);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> TransformActions.transformActions(inputPaths, targetBaseDir, spark));
    }

    private static void transformActions(String inputPaths, String targetBaseDir, SparkSession spark) throws IOException {
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        for (String sourcePath : Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)inputPaths))) {
            LinkedList pathQ = Lists.newLinkedList((Iterable)Splitter.on((String)SEPARATOR).split((CharSequence)sourcePath));
            String rawset = (String)pathQ.pollLast();
            String actionSetDirectory = (String)pathQ.pollLast();
            Path targetDirectory = new Path(targetBaseDir + SEPARATOR + actionSetDirectory + SEPARATOR + rawset);
            if (fs.exists(targetDirectory)) {
                log.info("found target directory '{}", (Object)targetDirectory);
                fs.delete(targetDirectory, true);
                log.info("deleted target directory '{}", (Object)targetDirectory);
            }
            log.info("transforming actions from '{}' to '{}'", (Object)sourcePath, (Object)targetDirectory);
            sc.sequenceFile(sourcePath, Text.class, Text.class).map((Function & Serializable)a -> AtomicAction.fromJSON((String)((Text)a._2()).toString())).map(TransformActions::doTransform).filter(Objects::nonNull).mapToPair((PairFunction & Serializable)a -> new Tuple2((Object)a.getClazz().toString(), (Object)OBJECT_MAPPER.writeValueAsString(a))).mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)new Text((String)t._1()), (Object)new Text((String)t._2()))).saveAsNewAPIHadoopFile(targetDirectory.toString(), Text.class, Text.class, SequenceFileOutputFormat.class, sc.hadoopConfiguration());
        }
    }

    private static eu.dnetlib.dhp.schema.action.AtomicAction doTransform(AtomicAction aa) throws InvalidProtocolBufferException {
        if (aa.getTargetValue().length == 0) {
            return null;
        }
        OafProtos.Oaf proto_oaf = OafProtos.Oaf.parseFrom((byte[])aa.getTargetValue());
        Oaf oaf = ProtoConverter.convert(proto_oaf);
        switch (proto_oaf.getKind()) {
            case entity: {
                switch (proto_oaf.getEntity().getType()) {
                    case datasource: {
                        return new eu.dnetlib.dhp.schema.action.AtomicAction(Datasource.class, (Oaf)((Datasource)oaf));
                    }
                    case organization: {
                        return new eu.dnetlib.dhp.schema.action.AtomicAction(Organization.class, (Oaf)((Organization)oaf));
                    }
                    case project: {
                        return new eu.dnetlib.dhp.schema.action.AtomicAction(Project.class, (Oaf)((Project)oaf));
                    }
                    case result: {
                        String resulttypeid;
                        switch (resulttypeid = proto_oaf.getEntity().getResult().getMetadata().getResulttype().getClassid()) {
                            case "publication": {
                                return new eu.dnetlib.dhp.schema.action.AtomicAction(Publication.class, (Oaf)((Publication)oaf));
                            }
                            case "software": {
                                return new eu.dnetlib.dhp.schema.action.AtomicAction(Software.class, (Oaf)((Software)oaf));
                            }
                            case "other": {
                                return new eu.dnetlib.dhp.schema.action.AtomicAction(OtherResearchProduct.class, (Oaf)((OtherResearchProduct)oaf));
                            }
                            case "dataset": {
                                return new eu.dnetlib.dhp.schema.action.AtomicAction(Dataset.class, (Oaf)((Dataset)oaf));
                            }
                        }
                        return new eu.dnetlib.dhp.schema.action.AtomicAction(Result.class, (Oaf)((Result)oaf));
                    }
                }
                throw new IllegalArgumentException("invalid entity type: " + proto_oaf.getEntity().getType());
            }
            case relation: {
                return new eu.dnetlib.dhp.schema.action.AtomicAction(Relation.class, (Oaf)((Relation)oaf));
            }
        }
        throw new IllegalArgumentException("invalid kind: " + proto_oaf.getKind());
    }

    private static String getTargetBaseDir(String isLookupUrl) throws ISLookUpException {
        ISLookUpService isLookUp = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        String XQUERY = "collection('/db/DRIVER/ServiceResources/ActionManagerServiceResourceType')//SERVICE_PROPERTIES/PROPERTY[@key = 'basePath']/@value/string()";
        return isLookUp.getResourceProfileByQuery(XQUERY);
    }
}

