/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.migration;

import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.dhp.actionmanager.migration.LicenseComparator;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OriginDescription;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProtoConverter
implements Serializable {
    public static Oaf convert(OafProtos.Oaf oaf) {
        try {
            switch (oaf.getKind()) {
                case entity: {
                    return ProtoConverter.convertEntity(oaf);
                }
                case relation: {
                    return ProtoConverter.convertRelation(oaf);
                }
            }
            throw new IllegalArgumentException("invalid kind " + oaf.getKind());
        }
        catch (Throwable e) {
            throw new RuntimeException("error on getting " + JsonFormat.printToString((Message)oaf), e);
        }
    }

    private static Relation convertRelation(OafProtos.Oaf oaf) {
        OafProtos.OafRel r = oaf.getRel();
        Relation rel = new Relation();
        rel.setDataInfo(ProtoConverter.mapDataInfo(oaf.getDataInfo()));
        rel.setLastupdatetimestamp(Long.valueOf(oaf.getLastupdatetimestamp()));
        rel.setSource(r.getSource());
        rel.setTarget(r.getTarget());
        rel.setRelType(r.getRelType().toString());
        rel.setSubRelType(r.getSubRelType().toString());
        rel.setRelClass(r.getRelClass());
        rel.setCollectedfrom(r.getCollectedfromCount() > 0 ? r.getCollectedfromList().stream().map(kv -> ProtoConverter.mapKV(kv)).collect(Collectors.toList()) : null);
        return rel;
    }

    private static OafEntity convertEntity(OafProtos.Oaf oaf) {
        switch (oaf.getEntity().getType()) {
            case result: {
                Result r = ProtoConverter.convertResult(oaf);
                r.setInstance(ProtoConverter.convertInstances(oaf));
                r.setExternalReference(ProtoConverter.convertExternalRefs(oaf));
                return r;
            }
            case project: {
                return ProtoConverter.convertProject(oaf);
            }
            case datasource: {
                return ProtoConverter.convertDataSource(oaf);
            }
            case organization: {
                return ProtoConverter.convertOrganization(oaf);
            }
        }
        throw new RuntimeException("received unknown type");
    }

    private static List<Instance> convertInstances(OafProtos.Oaf oaf) {
        ResultProtos.Result r = oaf.getEntity().getResult();
        if (r.getInstanceCount() > 0) {
            return r.getInstanceList().stream().map(i -> ProtoConverter.convertInstance(i)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private static Instance convertInstance(ResultProtos.Result.Instance ri) {
        Instance i = new Instance();
        i.setAccessright(ProtoConverter.mapQualifier(ri.getAccessright()));
        i.setCollectedfrom(ProtoConverter.mapKV(ri.getCollectedfrom()));
        i.setDateofacceptance(ProtoConverter.mapStringField(ri.getDateofacceptance()));
        i.setDistributionlocation(ri.getDistributionlocation());
        i.setHostedby(ProtoConverter.mapKV(ri.getHostedby()));
        i.setInstancetype(ProtoConverter.mapQualifier(ri.getInstancetype()));
        i.setLicense(ProtoConverter.mapStringField(ri.getLicense()));
        i.setUrl(ri.getUrlList() != null ? (List)ri.getUrlList().stream().distinct().collect(Collectors.toCollection(ArrayList::new)) : null);
        i.setRefereed(ProtoConverter.mapStringField(ri.getRefereed()));
        i.setProcessingchargeamount(ProtoConverter.mapStringField(ri.getProcessingchargeamount()));
        i.setProcessingchargecurrency(ProtoConverter.mapStringField(ri.getProcessingchargecurrency()));
        return i;
    }

    private static List<ExternalReference> convertExternalRefs(OafProtos.Oaf oaf) {
        ResultProtos.Result r = oaf.getEntity().getResult();
        if (r.getExternalReferenceCount() > 0) {
            return r.getExternalReferenceList().stream().map(e -> ProtoConverter.convertExtRef(e)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private static ExternalReference convertExtRef(ResultProtos.Result.ExternalReference e) {
        ExternalReference ex = new ExternalReference();
        ex.setUrl(e.getUrl());
        ex.setSitename(e.getSitename());
        ex.setRefidentifier(e.getRefidentifier());
        ex.setQuery(e.getQuery());
        ex.setQualifier(ProtoConverter.mapQualifier(e.getQualifier()));
        ex.setLabel(e.getLabel());
        ex.setDescription(e.getDescription());
        ex.setDataInfo(ex.getDataInfo());
        return ex;
    }

    private static Organization convertOrganization(OafProtos.Oaf oaf) {
        OrganizationProtos.Organization.Metadata m = oaf.getEntity().getOrganization().getMetadata();
        Organization org = ProtoConverter.setOaf(new Organization(), oaf);
        ProtoConverter.setEntity(org, oaf);
        org.setLegalshortname(ProtoConverter.mapStringField(m.getLegalshortname()));
        org.setLegalname(ProtoConverter.mapStringField(m.getLegalname()));
        org.setAlternativeNames(m.getAlternativeNamesList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        org.setWebsiteurl(ProtoConverter.mapStringField(m.getWebsiteurl()));
        org.setLogourl(ProtoConverter.mapStringField(m.getLogourl()));
        org.setEclegalbody(ProtoConverter.mapStringField(m.getEclegalbody()));
        org.setEclegalperson(ProtoConverter.mapStringField(m.getEclegalperson()));
        org.setEcnonprofit(ProtoConverter.mapStringField(m.getEcnonprofit()));
        org.setEcresearchorganization(ProtoConverter.mapStringField(m.getEcresearchorganization()));
        org.setEchighereducation(ProtoConverter.mapStringField(m.getEchighereducation()));
        org.setEcinternationalorganizationeurinterests(ProtoConverter.mapStringField(m.getEcinternationalorganizationeurinterests()));
        org.setEcinternationalorganization(ProtoConverter.mapStringField(m.getEcinternationalorganization()));
        org.setEcenterprise(ProtoConverter.mapStringField(m.getEcenterprise()));
        org.setEcsmevalidated(ProtoConverter.mapStringField(m.getEcsmevalidated()));
        org.setEcnutscode(ProtoConverter.mapStringField(m.getEcnutscode()));
        org.setCountry(ProtoConverter.mapQualifier(m.getCountry()));
        return org;
    }

    private static Datasource convertDataSource(OafProtos.Oaf oaf) {
        DatasourceProtos.Datasource.Metadata m = oaf.getEntity().getDatasource().getMetadata();
        Datasource datasource = ProtoConverter.setOaf(new Datasource(), oaf);
        ProtoConverter.setEntity(datasource, oaf);
        datasource.setAccessinfopackage(m.getAccessinfopackageList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        datasource.setCertificates(ProtoConverter.mapStringField(m.getCertificates()));
        datasource.setCitationguidelineurl(ProtoConverter.mapStringField(m.getCitationguidelineurl()));
        datasource.setContactemail(ProtoConverter.mapStringField(m.getContactemail()));
        datasource.setDatabaseaccessrestriction(ProtoConverter.mapStringField(m.getDatabaseaccessrestriction()));
        datasource.setDatabaseaccesstype(ProtoConverter.mapStringField(m.getDatabaseaccesstype()));
        datasource.setDataprovider(ProtoConverter.mapBoolField(m.getDataprovider()));
        datasource.setDatasourcetype(ProtoConverter.mapQualifier(m.getDatasourcetype()));
        datasource.setDatauploadrestriction(ProtoConverter.mapStringField(m.getDatauploadrestriction()));
        datasource.setCitationguidelineurl(ProtoConverter.mapStringField(m.getCitationguidelineurl()));
        datasource.setDatauploadtype(ProtoConverter.mapStringField(m.getDatauploadtype()));
        datasource.setDateofvalidation(ProtoConverter.mapStringField(m.getDateofvalidation()));
        datasource.setDescription(ProtoConverter.mapStringField(m.getDescription()));
        datasource.setEnglishname(ProtoConverter.mapStringField(m.getEnglishname()));
        datasource.setLatitude(ProtoConverter.mapStringField(m.getLatitude()));
        datasource.setLongitude(ProtoConverter.mapStringField(m.getLongitude()));
        datasource.setLogourl(ProtoConverter.mapStringField(m.getLogourl()));
        datasource.setMissionstatementurl(ProtoConverter.mapStringField(m.getMissionstatementurl()));
        datasource.setNamespaceprefix(ProtoConverter.mapStringField(m.getNamespaceprefix()));
        datasource.setOdcontenttypes(m.getOdcontenttypesList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        datasource.setOdlanguages(m.getOdlanguagesList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        datasource.setOdnumberofitems(ProtoConverter.mapStringField(m.getOdnumberofitems()));
        datasource.setOdnumberofitemsdate(ProtoConverter.mapStringField(m.getOdnumberofitemsdate()));
        datasource.setOdpolicies(ProtoConverter.mapStringField(m.getOdpolicies()));
        datasource.setOfficialname(ProtoConverter.mapStringField(m.getOfficialname()));
        datasource.setOpenairecompatibility(ProtoConverter.mapQualifier(m.getOpenairecompatibility()));
        datasource.setPidsystems(ProtoConverter.mapStringField(m.getPidsystems()));
        datasource.setPolicies(m.getPoliciesList().stream().map(ProtoConverter::mapKV).collect(Collectors.toList()));
        datasource.setQualitymanagementkind(ProtoConverter.mapStringField(m.getQualitymanagementkind()));
        datasource.setReleaseenddate(ProtoConverter.mapStringField(m.getReleaseenddate()));
        datasource.setServiceprovider(ProtoConverter.mapBoolField(m.getServiceprovider()));
        datasource.setReleasestartdate(ProtoConverter.mapStringField(m.getReleasestartdate()));
        datasource.setSubjects(m.getSubjectsList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        datasource.setVersioning(ProtoConverter.mapBoolField(m.getVersioning()));
        datasource.setWebsiteurl(ProtoConverter.mapStringField(m.getWebsiteurl()));
        datasource.setJournal(ProtoConverter.mapJournal(m.getJournal()));
        return datasource;
    }

    private static Project convertProject(OafProtos.Oaf oaf) {
        ProjectProtos.Project.Metadata m = oaf.getEntity().getProject().getMetadata();
        Project project = ProtoConverter.setOaf(new Project(), oaf);
        ProtoConverter.setEntity(project, oaf);
        project.setAcronym(ProtoConverter.mapStringField(m.getAcronym()));
        project.setCallidentifier(ProtoConverter.mapStringField(m.getCallidentifier()));
        project.setCode(ProtoConverter.mapStringField(m.getCode()));
        project.setContactemail(ProtoConverter.mapStringField(m.getContactemail()));
        project.setContactfax(ProtoConverter.mapStringField(m.getContactfax()));
        project.setContactfullname(ProtoConverter.mapStringField(m.getContactfullname()));
        project.setContactphone(ProtoConverter.mapStringField(m.getContactphone()));
        project.setContracttype(ProtoConverter.mapQualifier(m.getContracttype()));
        project.setCurrency(ProtoConverter.mapStringField(m.getCurrency()));
        project.setDuration(ProtoConverter.mapStringField(m.getDuration()));
        project.setEcarticle29_3(ProtoConverter.mapStringField(m.getEcarticle293()));
        project.setEcsc39(ProtoConverter.mapStringField(m.getEcsc39()));
        project.setOamandatepublications(ProtoConverter.mapStringField(m.getOamandatepublications()));
        project.setStartdate(ProtoConverter.mapStringField(m.getStartdate()));
        project.setEnddate(ProtoConverter.mapStringField(m.getEnddate()));
        project.setFundedamount(Float.valueOf(m.getFundedamount()));
        project.setTotalcost(Float.valueOf(m.getTotalcost()));
        project.setKeywords(ProtoConverter.mapStringField(m.getKeywords()));
        project.setSubjects(m.getSubjectsList().stream().map(sp -> ProtoConverter.mapStructuredProperty(sp)).collect(Collectors.toList()));
        project.setTitle(ProtoConverter.mapStringField(m.getTitle()));
        project.setWebsiteurl(ProtoConverter.mapStringField(m.getWebsiteurl()));
        project.setFundingtree(m.getFundingtreeList().stream().map(f -> ProtoConverter.mapStringField(f)).collect(Collectors.toList()));
        project.setJsonextrainfo(ProtoConverter.mapStringField(m.getJsonextrainfo()));
        project.setSummary(ProtoConverter.mapStringField(m.getSummary()));
        project.setOptional1(ProtoConverter.mapStringField(m.getOptional1()));
        project.setOptional2(ProtoConverter.mapStringField(m.getOptional2()));
        return project;
    }

    private static Result convertResult(OafProtos.Oaf oaf) {
        switch (oaf.getEntity().getResult().getMetadata().getResulttype().getClassid()) {
            case "dataset": {
                return ProtoConverter.createDataset(oaf);
            }
            case "publication": {
                return ProtoConverter.createPublication(oaf);
            }
            case "software": {
                return ProtoConverter.createSoftware(oaf);
            }
            case "other": {
                return ProtoConverter.createORP(oaf);
            }
        }
        Result result = ProtoConverter.setOaf(new Result(), oaf);
        ProtoConverter.setEntity(result, oaf);
        return ProtoConverter.setResult(result, oaf);
    }

    private static Software createSoftware(OafProtos.Oaf oaf) {
        ResultProtos.Result.Metadata m = oaf.getEntity().getResult().getMetadata();
        Software software = ProtoConverter.setOaf(new Software(), oaf);
        ProtoConverter.setEntity(software, oaf);
        ProtoConverter.setResult(software, oaf);
        software.setDocumentationUrl(m.getDocumentationUrlList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        software.setLicense(m.getLicenseList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        software.setCodeRepositoryUrl(ProtoConverter.mapStringField(m.getCodeRepositoryUrl()));
        software.setProgrammingLanguage(ProtoConverter.mapQualifier(m.getProgrammingLanguage()));
        return software;
    }

    private static OtherResearchProduct createORP(OafProtos.Oaf oaf) {
        ResultProtos.Result.Metadata m = oaf.getEntity().getResult().getMetadata();
        OtherResearchProduct otherResearchProducts = ProtoConverter.setOaf(new OtherResearchProduct(), oaf);
        ProtoConverter.setEntity(otherResearchProducts, oaf);
        ProtoConverter.setResult(otherResearchProducts, oaf);
        otherResearchProducts.setContactperson(m.getContactpersonList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        otherResearchProducts.setContactgroup(m.getContactgroupList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        otherResearchProducts.setTool(m.getToolList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        return otherResearchProducts;
    }

    private static Publication createPublication(OafProtos.Oaf oaf) {
        ResultProtos.Result.Metadata m = oaf.getEntity().getResult().getMetadata();
        Publication publication = ProtoConverter.setOaf(new Publication(), oaf);
        ProtoConverter.setEntity(publication, oaf);
        ProtoConverter.setResult(publication, oaf);
        publication.setJournal(ProtoConverter.mapJournal(m.getJournal()));
        return publication;
    }

    private static Dataset createDataset(OafProtos.Oaf oaf) {
        ResultProtos.Result.Metadata m = oaf.getEntity().getResult().getMetadata();
        Dataset dataset = ProtoConverter.setOaf(new Dataset(), oaf);
        ProtoConverter.setEntity(dataset, oaf);
        ProtoConverter.setResult(dataset, oaf);
        dataset.setStoragedate(ProtoConverter.mapStringField(m.getStoragedate()));
        dataset.setDevice(ProtoConverter.mapStringField(m.getDevice()));
        dataset.setSize(ProtoConverter.mapStringField(m.getSize()));
        dataset.setVersion(ProtoConverter.mapStringField(m.getVersion()));
        dataset.setLastmetadataupdate(ProtoConverter.mapStringField(m.getLastmetadataupdate()));
        dataset.setMetadataversionnumber(ProtoConverter.mapStringField(m.getMetadataversionnumber()));
        dataset.setGeolocation(m.getGeolocationList().stream().map(ProtoConverter::mapGeolocation).collect(Collectors.toList()));
        return dataset;
    }

    public static <T extends Oaf> T setOaf(T oaf, OafProtos.Oaf o) {
        oaf.setDataInfo(ProtoConverter.mapDataInfo(o.getDataInfo()));
        oaf.setLastupdatetimestamp(Long.valueOf(o.getLastupdatetimestamp()));
        return oaf;
    }

    public static <T extends OafEntity> T setEntity(T entity, OafProtos.Oaf oaf) {
        OafProtos.OafEntity e = oaf.getEntity();
        entity.setId(e.getId());
        entity.setOriginalId(e.getOriginalIdList());
        entity.setCollectedfrom(e.getCollectedfromList().stream().map(ProtoConverter::mapKV).collect(Collectors.toList()));
        entity.setPid(e.getPidList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        entity.setDateofcollection(e.getDateofcollection());
        entity.setDateoftransformation(e.getDateoftransformation());
        entity.setExtraInfo(e.getExtraInfoList().stream().map(ProtoConverter::mapExtraInfo).collect(Collectors.toList()));
        return entity;
    }

    public static <T extends Result> T setResult(T entity, OafProtos.Oaf oaf) {
        ResultProtos.Result.Metadata m = oaf.getEntity().getResult().getMetadata();
        entity.setAuthor(m.getAuthorList().stream().map(ProtoConverter::mapAuthor).collect(Collectors.toList()));
        entity.setResulttype(ProtoConverter.mapQualifier(m.getResulttype()));
        entity.setLanguage(ProtoConverter.mapQualifier(m.getLanguage()));
        entity.setCountry(m.getCountryList().stream().map(ProtoConverter::mapQualifierAsCountry).collect(Collectors.toList()));
        entity.setSubject(m.getSubjectList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        entity.setTitle(m.getTitleList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        entity.setRelevantdate(m.getRelevantdateList().stream().map(ProtoConverter::mapStructuredProperty).collect(Collectors.toList()));
        entity.setDescription(m.getDescriptionList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setDateofacceptance(ProtoConverter.mapStringField(m.getDateofacceptance()));
        entity.setPublisher(ProtoConverter.mapStringField(m.getPublisher()));
        entity.setEmbargoenddate(ProtoConverter.mapStringField(m.getEmbargoenddate()));
        entity.setSource(m.getSourceList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setFulltext(m.getFulltextList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setFormat(m.getFormatList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setContributor(m.getContributorList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setResourcetype(ProtoConverter.mapQualifier(m.getResourcetype()));
        entity.setCoverage(m.getCoverageList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        entity.setContext(m.getContextList().stream().map(ProtoConverter::mapContext).collect(Collectors.toList()));
        entity.setBestaccessright(ProtoConverter.getBestAccessRights(oaf.getEntity().getResult().getInstanceList()));
        return entity;
    }

    private static Qualifier getBestAccessRights(List<ResultProtos.Result.Instance> instanceList) {
        if (instanceList != null) {
            Qualifier rights;
            Optional<FieldTypeProtos.Qualifier> min = instanceList.stream().map(i -> i.getAccessright()).min(new LicenseComparator());
            Qualifier qualifier = rights = min.isPresent() ? ProtoConverter.mapQualifier(min.get()) : new Qualifier();
            if (StringUtils.isBlank((CharSequence)rights.getClassid())) {
                rights.setClassid("UNKNOWN");
            }
            if (StringUtils.isBlank((CharSequence)rights.getClassname()) || "UNKNOWN".equalsIgnoreCase(rights.getClassname())) {
                rights.setClassname("not available");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemeid())) {
                rights.setSchemeid("dnet:access_modes");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemename())) {
                rights.setSchemename("dnet:access_modes");
            }
            return rights;
        }
        return null;
    }

    private static Context mapContext(ResultProtos.Result.Context context) {
        Context entity = new Context();
        entity.setId(context.getId());
        entity.setDataInfo(context.getDataInfoList().stream().map(ProtoConverter::mapDataInfo).collect(Collectors.toList()));
        return entity;
    }

    public static KeyValue mapKV(FieldTypeProtos.KeyValue kv) {
        KeyValue keyValue = new KeyValue();
        keyValue.setKey(kv.getKey());
        keyValue.setValue(kv.getValue());
        keyValue.setDataInfo(ProtoConverter.mapDataInfo(kv.getDataInfo()));
        return keyValue;
    }

    public static DataInfo mapDataInfo(FieldTypeProtos.DataInfo d) {
        DataInfo dataInfo = new DataInfo();
        dataInfo.setDeletedbyinference(Boolean.valueOf(d.getDeletedbyinference()));
        dataInfo.setInferenceprovenance(d.getInferenceprovenance());
        dataInfo.setInferred(Boolean.valueOf(d.getInferred()));
        dataInfo.setInvisible(Boolean.valueOf(d.getInvisible()));
        dataInfo.setProvenanceaction(ProtoConverter.mapQualifier(d.getProvenanceaction()));
        dataInfo.setTrust(d.getTrust());
        return dataInfo;
    }

    public static Qualifier mapQualifier(FieldTypeProtos.Qualifier q) {
        Qualifier qualifier = new Qualifier();
        qualifier.setClassid(q.getClassid());
        qualifier.setClassname(q.getClassname());
        qualifier.setSchemeid(q.getSchemeid());
        qualifier.setSchemename(q.getSchemename());
        return qualifier;
    }

    public static Country mapQualifierAsCountry(FieldTypeProtos.Qualifier q) {
        Country c = new Country();
        c.setClassid(q.getClassid());
        c.setClassname(q.getClassname());
        c.setSchemeid(q.getSchemeid());
        c.setSchemename(q.getSchemename());
        c.setDataInfo(ProtoConverter.mapDataInfo(q.getDataInfo()));
        return c;
    }

    public static StructuredProperty mapStructuredProperty(FieldTypeProtos.StructuredProperty sp) {
        StructuredProperty structuredProperty = new StructuredProperty();
        structuredProperty.setValue(sp.getValue());
        structuredProperty.setQualifier(ProtoConverter.mapQualifier(sp.getQualifier()));
        structuredProperty.setDataInfo(ProtoConverter.mapDataInfo(sp.getDataInfo()));
        return structuredProperty;
    }

    public static ExtraInfo mapExtraInfo(FieldTypeProtos.ExtraInfo extraInfo) {
        ExtraInfo entity = new ExtraInfo();
        entity.setName(extraInfo.getName());
        entity.setTypology(extraInfo.getTypology());
        entity.setProvenance(extraInfo.getProvenance());
        entity.setTrust(extraInfo.getTrust());
        entity.setValue(extraInfo.getValue());
        return entity;
    }

    public static OAIProvenance mapOAIProvenance(FieldTypeProtos.OAIProvenance oaiProvenance) {
        OAIProvenance entity = new OAIProvenance();
        entity.setOriginDescription(ProtoConverter.mapOriginalDescription(oaiProvenance.getOriginDescription()));
        return entity;
    }

    public static OriginDescription mapOriginalDescription(FieldTypeProtos.OAIProvenance.OriginDescription originDescription) {
        OriginDescription originDescriptionResult = new OriginDescription();
        originDescriptionResult.setHarvestDate(originDescription.getHarvestDate());
        originDescriptionResult.setAltered(Boolean.valueOf(originDescription.getAltered()));
        originDescriptionResult.setBaseURL(originDescription.getBaseURL());
        originDescriptionResult.setIdentifier(originDescription.getIdentifier());
        originDescriptionResult.setDatestamp(originDescription.getDatestamp());
        originDescriptionResult.setMetadataNamespace(originDescription.getMetadataNamespace());
        return originDescriptionResult;
    }

    public static Field<String> mapStringField(FieldTypeProtos.StringField s) {
        Field stringField = new Field();
        stringField.setValue((Object)s.getValue());
        stringField.setDataInfo(ProtoConverter.mapDataInfo(s.getDataInfo()));
        return stringField;
    }

    public static Field<Boolean> mapBoolField(FieldTypeProtos.BoolField b) {
        Field booleanField = new Field();
        booleanField.setValue((Object)b.getValue());
        booleanField.setDataInfo(ProtoConverter.mapDataInfo(b.getDataInfo()));
        return booleanField;
    }

    public static Field<Integer> mapIntField(FieldTypeProtos.IntField b) {
        Field entity = new Field();
        entity.setValue((Object)b.getValue());
        entity.setDataInfo(ProtoConverter.mapDataInfo(b.getDataInfo()));
        return entity;
    }

    public static Journal mapJournal(FieldTypeProtos.Journal j) {
        Journal journal = new Journal();
        journal.setConferencedate(j.getConferencedate());
        journal.setConferenceplace(j.getConferenceplace());
        journal.setEdition(j.getEdition());
        journal.setEp(j.getEp());
        journal.setIss(j.getIss());
        journal.setIssnLinking(j.getIssnLinking());
        journal.setIssnOnline(j.getIssnOnline());
        journal.setIssnPrinted(j.getIssnPrinted());
        journal.setName(j.getName());
        journal.setSp(j.getSp());
        journal.setVol(j.getVol());
        journal.setDataInfo(ProtoConverter.mapDataInfo(j.getDataInfo()));
        return journal;
    }

    public static Author mapAuthor(FieldTypeProtos.Author author) {
        Author entity = new Author();
        entity.setFullname(author.getFullname());
        entity.setName(author.getName());
        entity.setSurname(author.getSurname());
        entity.setRank(Integer.valueOf(author.getRank()));
        entity.setPid(author.getPidList().stream().map(kv -> {
            StructuredProperty sp = new StructuredProperty();
            sp.setValue(kv.getValue());
            Qualifier q = new Qualifier();
            q.setClassid(kv.getKey());
            q.setClassname(kv.getKey());
            sp.setQualifier(q);
            return sp;
        }).collect(Collectors.toList()));
        entity.setAffiliation(author.getAffiliationList().stream().map(ProtoConverter::mapStringField).collect(Collectors.toList()));
        return entity;
    }

    public static GeoLocation mapGeolocation(ResultProtos.Result.GeoLocation geoLocation) {
        GeoLocation entity = new GeoLocation();
        entity.setPoint(geoLocation.getPoint());
        entity.setBox(geoLocation.getBox());
        entity.setPlace(geoLocation.getPlace());
        return entity;
    }
}

