/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnet.researcher.dto.CoAuthorDTO;
import eu.dnet.researcher.dto.CustomSolrResponse;
import eu.dnet.researcher.dto.ResearcherEmailDTO;
import eu.dnet.researcher.dto.ResearcherPidDTO;
import eu.dnet.researcher.dto.ResearcherProfileDTO;
import eu.dnet.researcher.mapper.ActivityMapper;
import eu.dnet.researcher.mapper.FundingMapper;
import eu.dnet.researcher.mapper.ResearcherEmailMapper;
import eu.dnet.researcher.mapper.ResearcherPidMapper;
import eu.dnet.researcher.mapper.ResearcherProfileMapper;
import eu.dnet.researcher.postgresql.Activity;
import eu.dnet.researcher.postgresql.Author;
import eu.dnet.researcher.postgresql.AuthorPublication;
import eu.dnet.researcher.postgresql.AuthorPublicationId;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.Publication;
import eu.dnet.researcher.postgresql.ResearcherEmail;
import eu.dnet.researcher.postgresql.ResearcherPid;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.repositories.ActivityRepository;
import eu.dnet.researcher.repositories.AuthorPublicationRepository;
import eu.dnet.researcher.repositories.AuthorRepository;
import eu.dnet.researcher.repositories.FundingRepository;
import eu.dnet.researcher.repositories.PublicationRepository;
import eu.dnet.researcher.repositories.ResearcherEmailRepository;
import eu.dnet.researcher.repositories.ResearcherPidRepository;
import eu.dnet.researcher.repositories.ResearcherProfileRepository;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResearcherProfileService {
    @Autowired
    ResearcherProfileRepository researcherProfileRepository;
    @Autowired
    ResearcherEmailRepository researcherEmailRepository;
    @Autowired
    ResearcherPidRepository researcherPidRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    FundingRepository fundingRepository;
    @Autowired
    AuthorRepository authorRepository;
    @Autowired
    PublicationRepository publicationRepository;
    @Autowired
    AuthorPublicationRepository authorPublicationRepository;
    @Autowired
    ResearcherProfileMapper researcherProfileMapper;
    @Autowired
    ResearcherEmailMapper researcherEmailMapper;
    @Autowired
    ResearcherPidMapper researcherPidMapper;
    @Autowired
    ActivityMapper activityMapper;
    @Autowired
    FundingMapper fundingMapper;
    ObjectMapper objectMapper = new ObjectMapper();

    public void addAoAuthorsWithPublications(String orcid) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OkHttpClient client = new OkHttpClient();
        String baseUrl = "http://rudie.di.uoa.gr:9111/browseAll/researcher-works";
        HttpUrl url = HttpUrl.parse((String)baseUrl).newBuilder().addQueryParameter("orcid", orcid).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response));
            }
            CustomSolrResponse response1 = (CustomSolrResponse)this.objectMapper.readValue(response.body().string(), CustomSolrResponse.class);
            for (SolrRecord result : response1.getBody().getResults()) {
                List authors = result.getResult().getAuthor().stream().filter(author -> author.getPid() != null).flatMap(author -> author.getPid().stream().filter(pid -> "orcid".equalsIgnoreCase(pid.getTypeCode()) && pid.getValue() != null).map(pid -> {
                    String orcidValue = pid.getValue();
                    if (orcidValue != null) {
                        return new Author(orcidValue, author.getFullname());
                    }
                    return null;
                })).filter(Objects::nonNull).collect(Collectors.toList());
                Publication publication = new Publication(result.getHeader().getId(), result.getResult().getMaintitle());
                for (Author author2 : authors) {
                    this.saveAuthorWithPublication(author2, publication);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Transactional
    public ResearcherProfileDTO initProfile(ResearcherProfileDTO researcherProfileDTO) {
        if (researcherProfileDTO.getId() != null) {
            throw new EntityExistsException("Profile with id " + researcherProfileDTO.getId() + " already exists!");
        }
        ResearcherProfileDTO savedProfileDTO = this.saveProfile(researcherProfileDTO);
        this.addAoAuthorsWithPublications(researcherProfileDTO.getOrcid());
        return savedProfileDTO;
    }

    @Transactional
    public ResearcherProfileDTO saveProfile(ResearcherProfileDTO researcherProfileDTO) {
        ResearcherProfile researcherProfile = this.researcherProfileMapper.toResearcherProfile(researcherProfileDTO);
        if (researcherProfile.getEmails() != null) {
            researcherProfile.getEmails().forEach(email -> email.setResearcher(researcherProfile));
        }
        if (researcherProfile.getPids() != null) {
            researcherProfile.getPids().forEach(pid -> pid.setResearcher(researcherProfile));
        }
        if (researcherProfile.getActivities() != null) {
            researcherProfile.getActivities().forEach(activity -> activity.setResearcher(researcherProfile));
        }
        if (researcherProfile.getFundings() != null) {
            researcherProfile.getFundings().forEach(funding -> funding.setResearcher(researcherProfile));
        }
        ResearcherProfile savedProfile = (ResearcherProfile)this.researcherProfileRepository.save((Object)researcherProfile);
        return this.researcherProfileMapper.toResearcherProfileDTO(savedProfile);
    }

    @Deprecated
    public ResearcherProfileDTO save(ResearcherProfileDTO researcherProfileDTO) {
        if (researcherProfileDTO.getId() != null) {
            throw new EntityExistsException("Profile with id " + researcherProfileDTO.getId() + " already exists!");
        }
        return this.saveResearcherProfile(researcherProfileDTO);
    }

    public ResearcherProfileDTO getProfile(Long id) {
        ResearcherProfile profile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Profile with " + id + "not found"));
        return this.researcherProfileMapper.toResearcherProfileDTO(profile);
    }

    public ResearcherProfileDTO getProfileByOrcid(String orcid) {
        ResearcherProfile profile = (ResearcherProfile)this.researcherProfileRepository.findTopByOrcidOrderByCreatedAtDesc(orcid).orElseThrow(() -> new EntityNotFoundException("Profile with orcid " + orcid + " not found"));
        return this.researcherProfileMapper.toResearcherProfileDTO(profile);
    }

    public ResearcherProfileDTO getProfileByOpenaireId(String openaireId) {
        ResearcherProfile profile = (ResearcherProfile)this.researcherProfileRepository.findByOpenaireId(openaireId).orElseThrow(() -> new EntityNotFoundException("Profile with openaireId " + openaireId + " not found"));
        return this.researcherProfileMapper.toResearcherProfileDTO(profile);
    }

    @Transactional
    public ResearcherProfileDTO partiallyUpdateProfile(ResearcherProfileDTO request) {
        if (request.getId() == null) {
            throw new IllegalArgumentException("Profile has null id! You cannot update a profile without a valid id");
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)request.getId()).orElseThrow(() -> new EntityNotFoundException("ResearcherProfile not found"));
        this.researcherProfileMapper.updateBasicResearcherProfileFromDto(request, researcherProfile);
        if (request.getEmails() != null) {
            researcherProfile.getEmails().forEach(email -> email.setResearcher(researcherProfile));
        }
        if (request.getPids() != null) {
            researcherProfile.getPids().forEach(pid -> pid.setResearcher(researcherProfile));
        }
        return this.researcherProfileMapper.toResearcherProfileDTO((ResearcherProfile)this.researcherProfileRepository.save((Object)researcherProfile));
    }

    @Transactional
    public void saveAuthorWithPublication(Author author, Publication publication) {
        String orcid = author.getOrcid();
        String openaireId = publication.getOpenaireId();
        Author authorEntity = this.authorRepository.findById((Object)orcid).orElseGet(() -> (Author)this.authorRepository.save((Object)author));
        Publication publicationEntity = this.publicationRepository.findById((Object)openaireId).orElseGet(() -> (Publication)this.publicationRepository.save((Object)publication));
        AuthorPublicationId authorPublicationId = new AuthorPublicationId();
        authorPublicationId.setOrcid(orcid);
        authorPublicationId.setOpenaireId(openaireId);
        if (!this.authorPublicationRepository.existsById((Object)authorPublicationId)) {
            AuthorPublication authorPublication = new AuthorPublication();
            authorPublication.setId(authorPublicationId);
            authorPublication.setAuthor(authorEntity);
            authorPublication.setPublication(publicationEntity);
            this.authorPublicationRepository.save((Object)authorPublication);
        }
    }

    public void deleteProfile(Integer id) {
        this.researcherProfileRepository.deleteById((Object)id.longValue());
    }

    public ResearcherEmailDTO saveEmail(Long researcherId, ResearcherEmailDTO researcherEmailDTO) {
        if (researcherEmailDTO.getId() != null) {
            Optional entity = this.researcherEmailRepository.findById((Object)researcherEmailDTO.getId());
            if (entity.isEmpty()) {
                throw new EntityNotFoundException("You cannot update the email with id " + researcherEmailDTO.getId() + ". It does not exist in DB");
            }
            if (!((ResearcherEmail)entity.get()).getResearcher().getId().equals(researcherId)) {
                throw new IllegalArgumentException("You cannot update the email with id " + researcherEmailDTO.getId() + ". It does not match the researcher id " + researcherId + ".");
            }
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Researcher with id " + researcherId + " not found"));
        ResearcherEmail updatedResearcherEmail = this.researcherEmailMapper.toEmail(researcherEmailDTO);
        updatedResearcherEmail.setResearcher(researcherProfile);
        return this.researcherEmailMapper.toEmailDTO((ResearcherEmail)this.researcherEmailRepository.save((Object)updatedResearcherEmail));
    }

    public void deleteEmail(Long emailId) {
        this.researcherEmailRepository.deleteById((Object)emailId);
    }

    public ResearcherPidDTO savePid(Long researcherId, ResearcherPidDTO researcherPidDTO) {
        if (researcherPidDTO.getId() != null) {
            Optional entity = this.researcherPidRepository.findById((Object)researcherPidDTO.getId());
            if (entity.isEmpty()) {
                throw new EntityNotFoundException("You cannot update the pid with id " + researcherPidDTO.getId() + ". It does not exist in DB");
            }
            if (!((ResearcherPid)entity.get()).getResearcher().getId().equals(researcherId)) {
                throw new IllegalArgumentException("You cannot update the pid with id " + researcherPidDTO.getId() + ". It does not match the researcher id " + researcherId + ".");
            }
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Researcher with id " + researcherId + " not found"));
        ResearcherPid researcherPid = this.researcherPidMapper.toResearcherPid(researcherPidDTO);
        researcherPid.setResearcher(researcherProfile);
        return this.researcherPidMapper.toResearcherPidDTO((ResearcherPid)this.researcherPidRepository.save((Object)researcherPid));
    }

    public void deletePid(Long pid) {
        this.researcherPidRepository.deleteById((Object)pid);
    }

    public void deleteFunding(Long pid) {
        this.fundingRepository.deleteById((Object)pid);
    }

    @Deprecated
    @NotNull
    private ResearcherProfileDTO saveResearcherProfile(ResearcherProfileDTO researcherProfileDTO) {
        ResearcherProfile savedResearcherProfile;
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.save((Object)this.researcherProfileMapper.toBasicResearcherProfile(researcherProfileDTO));
        List savedEmails = null;
        if (researcherProfileDTO.getEmails() != null) {
            List emails = researcherProfileDTO.getEmails().stream().filter(emailDto -> emailDto.getEmail() != null && !emailDto.getEmail().trim().isEmpty()).map(emailDto -> {
                ResearcherEmail email = this.researcherEmailMapper.toEmail(emailDto);
                email.setResearcher(researcherProfile);
                return email;
            }).collect(Collectors.toList());
            savedEmails = this.researcherEmailRepository.saveAll(emails);
        }
        List savedPids = null;
        if (researcherProfileDTO.getPids() != null) {
            List pids = researcherProfileDTO.getPids().stream().map(pidDTO -> {
                ResearcherPid pid = this.researcherPidMapper.toResearcherPid(pidDTO);
                pid.setResearcher(researcherProfile);
                return pid;
            }).collect(Collectors.toList());
            savedPids = this.researcherPidRepository.saveAll(pids);
        }
        List savedActivities = null;
        if (researcherProfileDTO.getActivities() != null) {
            List activities = researcherProfileDTO.getActivities().stream().map(activityDTO -> {
                Activity activity = this.activityMapper.toActivity(activityDTO);
                activity.setResearcher(researcherProfile);
                return activity;
            }).collect(Collectors.toList());
            savedActivities = this.activityRepository.saveAll(activities);
        }
        List savedFundings = null;
        if (researcherProfileDTO.getFundings() != null) {
            List fundings = researcherProfileDTO.getFundings().stream().map(fundingDTO -> {
                Funding funding = this.fundingMapper.toFunding(fundingDTO);
                funding.setResearcher(researcherProfile);
                return funding;
            }).collect(Collectors.toList());
            savedFundings = this.fundingRepository.saveAll(fundings);
        }
        if ((savedResearcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherProfile.getId()).orElseThrow(() -> new EntityNotFoundException("Save researcher failed."))).getEmails() == null || savedResearcherProfile.getEmails().isEmpty()) {
            savedResearcherProfile.setEmails(savedEmails);
        }
        if (savedResearcherProfile.getPids() == null || savedResearcherProfile.getPids().isEmpty()) {
            savedResearcherProfile.setPids(savedPids);
        }
        if (savedResearcherProfile.getActivities() == null || savedResearcherProfile.getActivities().isEmpty()) {
            savedResearcherProfile.setActivities(savedActivities);
        }
        if (savedResearcherProfile.getFundings() == null || savedResearcherProfile.getFundings().isEmpty()) {
            savedResearcherProfile.setFundings(savedFundings);
        }
        return this.researcherProfileMapper.toResearcherProfileDTO((ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherProfile.getId()).orElseThrow());
    }

    public List<CoAuthorDTO> findCoAuthors(String orcid) {
        return this.authorPublicationRepository.findCoAuthorsByOrcid(orcid);
    }

    public List<Integer> getAllYears(Long researcherId) {
        return this.researcherProfileRepository.getAllYears(researcherId);
    }
}

