/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnet.researcher.dto.NarrativeCvDTO;
import eu.dnet.researcher.postgresql.ModelServiceResponse;
import eu.dnet.researcher.postgresql.ModelServiceResponseList;
import eu.dnet.researcher.postgresql.NarrativeCv;
import eu.dnet.researcher.services.NarrativeCvHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@Service
public class NarrativeCvService {
    @Autowired
    private WebClient narrativeCvClient;
    ObjectMapper objectMapper = new ObjectMapper();

    public Mono<String> getModel(String modelId) {
        return this.narrativeCvClient.get().uri(uriBuilder -> uriBuilder.path("/forms/models/{id}").build(new Object[]{modelId})).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorMessage -> Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode().value(), "Error from Model Service API", clientResponse.headers().asHttpHeaders(), errorMessage.getBytes(), null)))).bodyToMono(String.class);
    }

    public Mono<NarrativeCvDTO> getNarrativeCv(Long researcherId, String modelId) {
        return this.narrativeCvClient.get().uri(uriBuilder -> uriBuilder.path("/search/{name}").queryParam("ownerId", new Object[]{"" + researcherId}).queryParam("sort", new Object[]{"modification_date"}).queryParam("modelId", new Object[]{modelId}).queryParam("order", new Object[]{"desc"}).build(new Object[]{"researcher_template_1"})).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorMessage -> Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode().value(), "Error from Model Service API", clientResponse.headers().asHttpHeaders(), errorMessage.getBytes(), null)))).bodyToMono(String.class).flatMap(arg_0 -> this.processGetResponse(arg_0));
    }

    public Mono<NarrativeCvDTO> postNarrativeCv(NarrativeCv narrativeCv) {
        return ((WebClient.RequestBodySpec)this.narrativeCvClient.post().uri("/resources", new Object[0])).bodyValue((Object)narrativeCv).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorMessage -> Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode().value(), "Error from Model Service API", clientResponse.headers().asHttpHeaders(), errorMessage.getBytes(), null)))).bodyToMono(String.class).flatMap(arg_0 -> this.processPostResponse(arg_0));
    }

    private Mono<NarrativeCvDTO> processGetResponse(String responseBody) {
        try {
            ModelServiceResponseList modelServiceResponseList = (ModelServiceResponseList)this.objectMapper.readValue(responseBody, ModelServiceResponseList.class);
            if (modelServiceResponseList.getResults().length > 0) {
                NarrativeCvDTO narrativeCvDTO = this.extractNarrativeCvDTO(modelServiceResponseList.getResults()[0]);
                return Mono.just((Object)narrativeCvDTO);
            }
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Resource not found"));
        }
        catch (JsonProcessingException e) {
            System.err.println((Object)e);
            return Mono.error((Throwable)new RuntimeException("Error deserializing response", e));
        }
    }

    private Mono<NarrativeCvDTO> processPostResponse(String responseBody) {
        try {
            ModelServiceResponse modelServiceResponse = (ModelServiceResponse)this.objectMapper.readValue(responseBody, ModelServiceResponse.class);
            NarrativeCvDTO narrativeCvDTO = this.extractNarrativeCvDTO(modelServiceResponse);
            return Mono.just((Object)narrativeCvDTO);
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)new RuntimeException("Error deserializing response", e));
        }
    }

    private NarrativeCvDTO extractNarrativeCvDTO(ModelServiceResponse modelServiceResponse) throws JsonProcessingException {
        NarrativeCvHelper helper = (NarrativeCvHelper)this.objectMapper.readValue(modelServiceResponse.getPayload(), NarrativeCvHelper.class);
        NarrativeCvDTO narrativeCvDTO = NarrativeCvDTO.builder().id(modelServiceResponse.getId()).modelId(modelServiceResponse.getResourceTypeName()).version(modelServiceResponse.getVersion()).ownerId(Long.valueOf(helper.getOwnerId())).answer(helper.getAnswer()).build();
        return narrativeCvDTO;
    }
}

