/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.mapper;

import eu.dnet.researcher.dto.FundingDTO;
import eu.dnet.researcher.mapper.FundingMapper;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.utils.LocalDateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FundingMapperImpl
implements FundingMapper {
    @Autowired
    private LocalDateHelper localDateHelper;

    public FundingDTO toFundingDTO(Funding funding) {
        if (funding == null) {
            return null;
        }
        FundingDTO fundingDTO = new FundingDTO();
        fundingDTO.setResearcherId(this.fundingResearcherId(funding));
        fundingDTO.setFromDate(this.localDateHelper.convertLocalDate(funding.getFromDate()));
        fundingDTO.setToDate(this.localDateHelper.convertLocalDate(funding.getToDate()));
        fundingDTO.setId(funding.getId());
        fundingDTO.setActivityConfiguration(funding.getActivityConfiguration());
        fundingDTO.setTitle(funding.getTitle());
        fundingDTO.setFundingType(funding.getFundingType());
        fundingDTO.setFundingIdType(funding.getFundingIdType());
        fundingDTO.setFundingIdValue(funding.getFundingIdValue());
        fundingDTO.setFundingRelationship(funding.getFundingRelationship());
        fundingDTO.setSource(funding.getSource());
        fundingDTO.setSynced(funding.getSynced());
        fundingDTO.setOrganizationName(funding.getOrganizationName());
        fundingDTO.setOrganizationCity(funding.getOrganizationCity());
        fundingDTO.setOrganizationCountry(funding.getOrganizationCountry());
        fundingDTO.setOrganizationUrl(funding.getOrganizationUrl());
        fundingDTO.setOrganizationDisId(funding.getOrganizationDisId());
        fundingDTO.setOrganizationDisSource(funding.getOrganizationDisSource());
        fundingDTO.setVisibility(funding.getVisibility());
        fundingDTO.setOrcidPutCode(funding.getOrcidPutCode());
        return fundingDTO;
    }

    public Funding toFunding(FundingDTO fundingDTO) {
        if (fundingDTO == null) {
            return null;
        }
        Funding.FundingBuilder funding = Funding.builder();
        if (fundingDTO.getFromDate() != null) {
            funding.fromDate(this.localDateHelper.convertTimestamp(String.valueOf(fundingDTO.getFromDate())));
        }
        if (fundingDTO.getToDate() != null) {
            funding.toDate(this.localDateHelper.convertTimestamp(String.valueOf(fundingDTO.getToDate())));
        }
        funding.id(fundingDTO.getId());
        funding.activityConfiguration(fundingDTO.getActivityConfiguration());
        funding.title(fundingDTO.getTitle());
        funding.fundingType(fundingDTO.getFundingType());
        funding.fundingIdType(fundingDTO.getFundingIdType());
        funding.fundingIdValue(fundingDTO.getFundingIdValue());
        funding.fundingRelationship(fundingDTO.getFundingRelationship());
        funding.source(fundingDTO.getSource());
        funding.synced(fundingDTO.getSynced());
        funding.organizationName(fundingDTO.getOrganizationName());
        funding.organizationCity(fundingDTO.getOrganizationCity());
        funding.organizationCountry(fundingDTO.getOrganizationCountry());
        funding.organizationUrl(fundingDTO.getOrganizationUrl());
        funding.organizationDisId(fundingDTO.getOrganizationDisId());
        funding.organizationDisSource(fundingDTO.getOrganizationDisSource());
        funding.visibility(fundingDTO.getVisibility());
        funding.orcidPutCode(fundingDTO.getOrcidPutCode());
        return funding.build();
    }

    private Long fundingResearcherId(Funding funding) {
        if (funding == null) {
            return null;
        }
        ResearcherProfile researcher = funding.getResearcher();
        if (researcher == null) {
            return null;
        }
        Long id = researcher.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

