/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.NarrativeCvDTO;
import eu.dnet.researcher.mapper.NarrativeCvMapper;
import eu.dnet.researcher.services.NarrativeCvService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"narratives"})
public class NarrativeCvController {
    @Autowired
    NarrativeCvService service;
    @Autowired
    NarrativeCvMapper narrativeCvMapper;

    @GetMapping(value={"/models/{id}"}, produces={"application/json"})
    public Mono<ResponseEntity<Object>> getModel(@PathVariable(value="id") String id) {
        return this.service.getModel(id).map(retrievedItem -> ResponseEntity.ok().body(retrievedItem)).onErrorResume(WebClientResponseException.class, ex -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).body((Object)ex.getResponseBodyAsString())));
    }

    @GetMapping
    public Mono<ResponseEntity<Object>> getNarrative(Long id, String modelId) {
        return this.service.getNarrativeCv(id, modelId).map(retrievedItem -> ResponseEntity.ok().body(retrievedItem)).onErrorResume(ResponseStatusException.class, ex -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).body(Map.of("status", ex.getStatusCode().value(), "error", ex.getReason())))).onErrorResume(WebClientResponseException.class, ex -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).body(Map.of("status", ex.getStatusCode().value(), "error", ex.getResponseBodyAsString()))));
    }

    @PostMapping
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#narrativeCvDTO.ownerId)) : true")
    public Mono<ResponseEntity<Object>> createNarrativeCv(@RequestBody NarrativeCvDTO narrativeCvDTO) {
        return this.service.postNarrativeCv(this.narrativeCvMapper.toNarrativeCv(narrativeCvDTO)).map(savedItem -> ResponseEntity.ok().body(savedItem)).onErrorResume(WebClientResponseException.class, ex -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).body((Object)ex.getResponseBodyAsString())));
    }
}

