/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.FeaturedArticleDTO;
import eu.dnet.researcher.services.FeaturedArticleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/featured-articles"})
public class FeaturedArticleController {
    @Autowired
    private FeaturedArticleService featuredArticleService;

    public FeaturedArticleController(FeaturedArticleService featuredArticleService) {
        this.featuredArticleService = featuredArticleService;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<FeaturedArticleDTO> createArticle(@RequestBody FeaturedArticleDTO dto) {
        return ResponseEntity.ok((Object)this.featuredArticleService.createArticle(dto));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<FeaturedArticleDTO> getArticle(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.featuredArticleService.getArticleById(id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<FeaturedArticleDTO> updateArticle(@RequestBody FeaturedArticleDTO dto) {
        return ResponseEntity.ok((Object)this.featuredArticleService.updateArticle(dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteArticle(@PathVariable Long id) {
        this.featuredArticleService.deleteArticle(id);
        return ResponseEntity.noContent().build();
    }
}

