/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.repositories;

import eu.dnet.researcher.postgresql.Activity;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ActivityRepository
extends JpaRepository<Activity, Long> {
    public List<Activity> findByResearcherId(Long var1);

    public List<Activity> findByActivityConfigurationAndResearcherId(Long var1, Long var2);

    @Query(value="SELECT a FROM Activity a WHERE a.fromDate <= :endDate AND a.toDate >= :startDate")
    public List<Activity> findActivitiesByYearRange(LocalDate var1, LocalDate var2);

    @Query(value="SELECT a FROM Activity a WHERE ((a.fromDate <= :endDate AND a.toDate >= :startDate) OR (a.toDate IS NULL and a.fromDate >= :startDate and a.fromDate <= :endDate) OR (a.fromDate IS NULL and a.toDate >= :startDate and a.toDate <= :endDate)) AND (a.researcher.id = :researcherId)")
    public List<Activity> findByResearcherIdAndYearRange(Long var1, LocalDate var2, LocalDate var3);

    @Query(value="SELECT a FROM Activity a WHERE ((a.fromDate <= :endDate AND a.toDate >= :startDate) OR (a.toDate IS NULL and a.fromDate >= :startDate and a.fromDate <= :endDate) OR (a.fromDate IS NULL and a.toDate >= :startDate and a.toDate <= :endDate)) AND (a.researcher.id = :researcherId AND a.activityConfiguration = :activityId)")
    public List<Activity> findByActivityIdAndResearcherIdAndYearRange(Long var1, Long var2, LocalDate var3, LocalDate var4);

    @Query(value="SELECT MIN(a.fromDate) FROM Activity a WHERE a.researcher.id = :researcherId")
    public LocalDate findEarliestFromDateByResearcher(Long var1);

    @Query(value="SELECT DISTINCT YEAR(a.fromDate) FROM Activity a WHERE a.researcher.id = :researcherId AND a.fromDate IS NOT NULL ORDER BY YEAR(a.fromDate)")
    public List<Integer> findAllYears(Long var1);

    @Query(value="SELECT MIN(a.fromDate) FROM Activity a")
    public LocalDate findEarliestFromDate();

    @Query(value="SELECT a.fromDate FROM Activity a")
    public List<LocalDate> findAllFromDates();
}

