/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.controllers;

import eu.dnetlib.uoaorcidservice.services.MetricsService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetricsController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Logger orcid_log = LogManager.getLogger((String)("ORCID-" + this.getClass().getName()));
    private final MetricsService metricsService;

    @Autowired
    public MetricsController(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    @RequestMapping(value={"/report/worksPerDashboard"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countWorksPerDashboard() {
        return ResponseEntity.ok((Object)this.metricsService.countWorksPerDashboard());
    }

    @RequestMapping(value={"/report/worksPerYear"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countWorksPerYear() {
        return ResponseEntity.ok((Object)this.metricsService.countWorksPerYear());
    }

    @RequestMapping(value={"/report/worksPerYearAndMonth"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countWorksPerYearAndMonth() {
        return ResponseEntity.ok((Object)this.metricsService.countWorksPerYearAndMonth());
    }

    @RequestMapping(value={"/report/worksPerOrcid"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countWorksPerOrcid() {
        return ResponseEntity.ok((Object)this.metricsService.countWorksPerOrcid());
    }

    @RequestMapping(value={"/report/uniqueUsersWithLinksPerMonth"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countUniqueUsersWithLinksPerMonth() {
        return ResponseEntity.ok((Object)this.metricsService.countUniqueUsersWithLinksPerMonth());
    }

    @RequestMapping(value={"/report/uniqueUsersWithLinksPerYear"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countUniqueUsersWithLinksPerYear() {
        return ResponseEntity.ok((Object)this.metricsService.countUniqueUsersWithLinksPerYear());
    }

    @RequestMapping(value={"/report/newUsersPerMonth"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countNewUsersPerMonth() {
        return ResponseEntity.ok((Object)this.metricsService.countNewUsersPerMonth());
    }

    @RequestMapping(value={"/report/newUsersPerYear"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countNewUsersPerYear() {
        return ResponseEntity.ok((Object)this.metricsService.countNewUsersPerYear());
    }

    @RequestMapping(value={"/report/tokensPerOrcid"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countTokensPerOrcid() {
        return ResponseEntity.ok((Object)this.metricsService.countTokensPerOrcid());
    }

    @RequestMapping(value={"/report/totalUniqueUsers"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countTotalUniqueUsers() {
        return ResponseEntity.ok((Object)this.metricsService.countTotalUniqueUsers());
    }

    @RequestMapping(value={"/report/totalWorks"}, method={RequestMethod.GET})
    public ResponseEntity<List<Object>> countTotalWorks() {
        return ResponseEntity.ok((Object)this.metricsService.countTotalWorks());
    }

    @RequestMapping(value={"/report/metrics"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getMetrics() {
        return ResponseEntity.ok((Object)this.metricsService.getMetrics());
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/report/calc"}, method={RequestMethod.GET})
    public ResponseEntity<String> calculateMetrics() {
        this.metricsService.calculateMetrics();
        return ResponseEntity.ok((Object)"ALL GOOD");
    }
}

